<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Send ServiceType
 * @subpackage Services
 */
class Send extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SendRecapiti
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SendRecapiti $parameters
     * @return SendRecapitiResponse|bool
     */
    public function SendRecapiti(SendRecapiti $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendRecapiti($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendCorsoRegistrazione
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SendCorsoRegistrazione $parameters
     * @return SendCorsoRegistrazioneResponse|bool
     */
    public function SendCorsoRegistrazione(SendCorsoRegistrazione $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendCorsoRegistrazione($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendCorsoCancellaRegistrazione
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SendCorsoCancellaRegistrazione $parameters
     * @return SendCorsoCancellaRegistrazioneResponse|bool
     */
    public function SendCorsoCancellaRegistrazione(SendCorsoCancellaRegistrazione $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendCorsoCancellaRegistrazione($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SendSegnalazioneGuasto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SendSegnalazioneGuasto $parameters
     * @return SendSegnalazioneGuastoResponse|bool
     */
    public function SendSegnalazioneGuasto(SendSegnalazioneGuasto $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SendSegnalazioneGuasto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return SendCorsoCancellaRegistrazioneResponse|SendCorsoRegistrazioneResponse|SendRecapitiResponse|SendSegnalazioneGuastoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
