<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Salva ServiceType
 * @subpackage Services
 */
class Salva extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SalvaRecapito
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SalvaRecapito $parameters
     * @return SalvaRecapitoResponse|bool
     */
    public function SalvaRecapito(SalvaRecapito $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SalvaRecapito($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SalvaAnagrafe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param SalvaAnagrafe $parameters
     * @return SalvaAnagrafeResponse|bool
     */
    public function SalvaAnagrafe(SalvaAnagrafe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SalvaAnagrafe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return SalvaAnagrafeResponse|SalvaRecapitoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
