<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Rinnova ServiceType
 * @subpackage Services
 */
class Rinnova extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RinnovaPrivacy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param RinnovaPrivacy $parameters
     * @return RinnovaPrivacyResponse|bool
     */
    public function RinnovaPrivacy(RinnovaPrivacy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RinnovaPrivacy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return RinnovaPrivacyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
