<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Revoca ServiceType
 * @subpackage Services
 */
class Revoca extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RevocaPrivacy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param RevocaPrivacy $parameters
     * @return RevocaPrivacyResponse|bool
     */
    public function RevocaPrivacy(RevocaPrivacy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RevocaPrivacy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return RevocaPrivacyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
