<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Report_Get_Result StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Report_Get_Result
 * @subpackage Structs
 */
class Report_Get_Result extends WebService_GenericResult
{
    /**
     * The Report
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Report;
    /**
     * Constructor method for Report_Get_Result
     * @uses Report_Get_Result::setReport()
     * @param string $report
     */
    public function __construct($report = null)
    {
        $this
            ->setReport($report);
    }
    /**
     * Get Report value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReport()
    {
        return isset($this->Report) ? $this->Report : null;
    }
    /**
     * Set Report value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $report
     * @return Report_Get_Result
     */
    public function setReport($report = null)
    {
        // validation for constraint: string
        if (!is_null($report) && !is_string($report)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($report, true), gettype($report)), __LINE__);
        }
        if (is_null($report) || (is_array($report) && empty($report))) {
            unset($this->Report);
        } else {
            $this->Report = $report;
        }
        return $this;
    }
}
