<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Iscrizione ServiceType
 * @subpackage Services
 */
class Iscrizione extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IscrizioneTurno
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param IscrizioneTurno $parameters
     * @return IscrizioneTurnoResponse|bool
     */
    public function IscrizioneTurno(IscrizioneTurno $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IscrizioneTurno($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IscrizioneTurno2
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param IscrizioneTurno2 $parameters
     * @return IscrizioneTurno2Response|bool
     */
    public function IscrizioneTurno2(IscrizioneTurno2 $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IscrizioneTurno2($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named IscrizioneEvento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param IscrizioneEvento $parameters
     * @return IscrizioneEventoResponse|bool
     */
    public function IscrizioneEvento(IscrizioneEvento $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IscrizioneEvento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return IscrizioneEventoResponse|IscrizioneTurno2Response|IscrizioneTurnoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
