<?php
use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Incassa ServiceType
 * @subpackage Services
 */
class Incassa extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named IncassaQuotaAssociativa
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param IncassaQuotaAssociativa $parameters
     * @return IncassaQuotaAssociativaResponse|bool
     */
    public function IncassaQuotaAssociativa(IncassaQuotaAssociativa $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->IncassaQuotaAssociativa($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return IncassaQuotaAssociativaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
