<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMessaggi_Result StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetMessaggi_Result
 * @subpackage Structs
 */
class GetMessaggi_Result extends AbstractStructBase
{
    /**
     * The Informazioni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var AdditionaInformation
     */
    public $Informazioni;
    /**
     * The Messaggi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfMessaggio
     */
    public $Messaggi;
    /**
     * Constructor method for GetMessaggi_Result
     * @uses GetMessaggi_Result::setInformazioni()
     * @uses GetMessaggi_Result::setMessaggi()
     * @param AdditionaInformation $informazioni
     * @param ArrayOfMessaggio $messaggi
     */
    public function __construct(AdditionaInformation $informazioni = null, ArrayOfMessaggio $messaggi = null)
    {
        $this
            ->setInformazioni($informazioni)
            ->setMessaggi($messaggi);
    }
    /**
     * Get Informazioni value
     * @return AdditionaInformation|null
     */
    public function getInformazioni()
    {
        return $this->Informazioni;
    }
    /**
     * Set Informazioni value
     * @param AdditionaInformation $informazioni
     * @return GetMessaggi_Result
     */
    public function setInformazioni(AdditionaInformation $informazioni = null)
    {
        $this->Informazioni = $informazioni;
        return $this;
    }
    /**
     * Get Messaggi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfMessaggio|null
     */
    public function getMessaggi()
    {
        return isset($this->Messaggi) ? $this->Messaggi : null;
    }
    /**
     * Set Messaggi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfMessaggio $messaggi
     * @return GetMessaggi_Result
     */
    public function setMessaggi(ArrayOfMessaggio $messaggi = null)
    {
        if (is_null($messaggi) || (is_array($messaggi) && empty($messaggi))) {
            unset($this->Messaggi);
        } else {
            $this->Messaggi = $messaggi;
        }
        return $this;
    }
}
