<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CorsoFormazione StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:CorsoFormazione
 * @subpackage Structs
 */
class CorsoFormazione extends AbstractStructBase
{
    /**
     * The Descrizione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descrizione;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The QualificaFinale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var Qualifica
     */
    public $QualificaFinale;
    /**
     * The QualificaIniziale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var Qualifica
     */
    public $QualificaIniziale;
    /**
     * Constructor method for CorsoFormazione
     * @uses CorsoFormazione::setDescrizione()
     * @uses CorsoFormazione::setID()
     * @uses CorsoFormazione::setQualificaFinale()
     * @uses CorsoFormazione::setQualificaIniziale()
     * @param string $descrizione
     * @param int $iD
     * @param Qualifica $qualificaFinale
     * @param Qualifica $qualificaIniziale
     */
    public function __construct($descrizione = null, $iD = null, Qualifica $qualificaFinale = null, Qualifica $qualificaIniziale = null)
    {
        $this
            ->setDescrizione($descrizione)
            ->setID($iD)
            ->setQualificaFinale($qualificaFinale)
            ->setQualificaIniziale($qualificaIniziale);
    }
    /**
     * Get Descrizione value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescrizione()
    {
        return isset($this->Descrizione) ? $this->Descrizione : null;
    }
    /**
     * Set Descrizione value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descrizione
     * @return CorsoFormazione
     */
    public function setDescrizione($descrizione = null)
    {
        // validation for constraint: string
        if (!is_null($descrizione) && !is_string($descrizione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descrizione, true), gettype($descrizione)), __LINE__);
        }
        if (is_null($descrizione) || (is_array($descrizione) && empty($descrizione))) {
            unset($this->Descrizione);
        } else {
            $this->Descrizione = $descrizione;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return CorsoFormazione
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get QualificaFinale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return Qualifica|null
     */
    public function getQualificaFinale()
    {
        return isset($this->QualificaFinale) ? $this->QualificaFinale : null;
    }
    /**
     * Set QualificaFinale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param Qualifica $qualificaFinale
     * @return CorsoFormazione
     */
    public function setQualificaFinale(Qualifica $qualificaFinale = null)
    {
        if (is_null($qualificaFinale) || (is_array($qualificaFinale) && empty($qualificaFinale))) {
            unset($this->QualificaFinale);
        } else {
            $this->QualificaFinale = $qualificaFinale;
        }
        return $this;
    }
    /**
     * Get QualificaIniziale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return Qualifica|null
     */
    public function getQualificaIniziale()
    {
        return isset($this->QualificaIniziale) ? $this->QualificaIniziale : null;
    }
    /**
     * Set QualificaIniziale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param Qualifica $qualificaIniziale
     * @return CorsoFormazione
     */
    public function setQualificaIniziale(Qualifica $qualificaIniziale = null)
    {
        if (is_null($qualificaIniziale) || (is_array($qualificaIniziale) && empty($qualificaIniziale))) {
            unset($this->QualificaIniziale);
        } else {
            $this->QualificaIniziale = $qualificaIniziale;
        }
        return $this;
    }
}
