<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Configurazione StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Configurazione
 * @subpackage Structs
 */
class Configurazione extends ConfigurazioneBase
{
    /**
     * The AnagrafeModifica
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $AnagrafeModifica;
    /**
     * The CupMisericordie
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var IntegrazioneCupMisericordie
     */
    public $CupMisericordie;
    /**
     * The CupSubito
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var IntegrazioneCupSubito
     */
    public $CupSubito;
    /**
     * The DisabilitaControlloScadenzaQualifiche
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $DisabilitaControlloScadenzaQualifiche;
    /**
     * The EVENTI_IntervalloGiorni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $EVENTI_IntervalloGiorni;
    /**
     * The EVENTI_SelezioneManualeAttivita
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $EVENTI_SelezioneManualeAttivita;
    /**
     * The EVENTI_VincolaSezione
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $EVENTI_VincolaSezione;
    /**
     * The Mezzi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfMezzo_Model
     */
    public $Mezzi;
    /**
     * The MotiviRichiestaCartellino
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfRichiestaCartellino_Motivo
     */
    public $MotiviRichiestaCartellino;
    /**
     * The PRESENZE_TipoControllo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PRESENZE_TipoControllo;
    /**
     * The Profilo_CaricaImmagine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Profilo_CaricaImmagine;
    /**
     * The Profilo_RicaricaImmagine
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Profilo_RicaricaImmagine;
    /**
     * The SegnalaGuasti
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SegnalaGuasti;
    /**
     * The SegnalaGuastiMezzo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SegnalaGuastiMezzo;
    /**
     * The Sezioni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfSezione
     */
    public $Sezioni;
    /**
     * The Sezioni2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfSezione_Model
     */
    public $Sezioni2;
    /**
     * The TURNI_IntervalloGiorni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TURNI_IntervalloGiorni;
    /**
     * The TURNI_MostraSiglaMezzo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TURNI_MostraSiglaMezzo;
    /**
     * The TURNI_SelezioneManualeAttivita
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $TURNI_SelezioneManualeAttivita;
    /**
     * The TipiRecapito
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var ArrayOfTipoRecapito
     */
    public $TipiRecapito;
    /**
     * The UtenteAmministratore
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UtenteAmministratore;
    /**
     * The VisualizzaMenuAnagrafe
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $VisualizzaMenuAnagrafe;
    /**
     * The VisualizzaMenuCorsi
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $VisualizzaMenuCorsi;
    /**
     * The VisualizzaMenuPresenze
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $VisualizzaMenuPresenze;
    /**
     * The VisualizzaMenuTurni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $VisualizzaMenuTurni;
    /**
     * Constructor method for Configurazione
     * @uses Configurazione::setAnagrafeModifica()
     * @uses Configurazione::setCupMisericordie()
     * @uses Configurazione::setCupSubito()
     * @uses Configurazione::setDisabilitaControlloScadenzaQualifiche()
     * @uses Configurazione::setEVENTI_IntervalloGiorni()
     * @uses Configurazione::setEVENTI_SelezioneManualeAttivita()
     * @uses Configurazione::setEVENTI_VincolaSezione()
     * @uses Configurazione::setMezzi()
     * @uses Configurazione::setMotiviRichiestaCartellino()
     * @uses Configurazione::setPRESENZE_TipoControllo()
     * @uses Configurazione::setProfilo_CaricaImmagine()
     * @uses Configurazione::setProfilo_RicaricaImmagine()
     * @uses Configurazione::setSegnalaGuasti()
     * @uses Configurazione::setSegnalaGuastiMezzo()
     * @uses Configurazione::setSezioni()
     * @uses Configurazione::setSezioni2()
     * @uses Configurazione::setTURNI_IntervalloGiorni()
     * @uses Configurazione::setTURNI_MostraSiglaMezzo()
     * @uses Configurazione::setTURNI_SelezioneManualeAttivita()
     * @uses Configurazione::setTipiRecapito()
     * @uses Configurazione::setUtenteAmministratore()
     * @uses Configurazione::setVisualizzaMenuAnagrafe()
     * @uses Configurazione::setVisualizzaMenuCorsi()
     * @uses Configurazione::setVisualizzaMenuPresenze()
     * @uses Configurazione::setVisualizzaMenuTurni()
     * @param bool $anagrafeModifica
     * @param IntegrazioneCupMisericordie $cupMisericordie
     * @param IntegrazioneCupSubito $cupSubito
     * @param bool $disabilitaControlloScadenzaQualifiche
     * @param int $eVENTI_IntervalloGiorni
     * @param bool $eVENTI_SelezioneManualeAttivita
     * @param bool $eVENTI_VincolaSezione
     * @param ArrayOfMezzo_Model $mezzi
     * @param ArrayOfRichiestaCartellino_Motivo $motiviRichiestaCartellino
     * @param string $pRESENZE_TipoControllo
     * @param bool $profilo_CaricaImmagine
     * @param bool $profilo_RicaricaImmagine
     * @param bool $segnalaGuasti
     * @param bool $segnalaGuastiMezzo
     * @param ArrayOfSezione $sezioni
     * @param ArrayOfSezione_Model $sezioni2
     * @param int $tURNI_IntervalloGiorni
     * @param bool $tURNI_MostraSiglaMezzo
     * @param bool $tURNI_SelezioneManualeAttivita
     * @param ArrayOfTipoRecapito $tipiRecapito
     * @param bool $utenteAmministratore
     * @param bool $visualizzaMenuAnagrafe
     * @param bool $visualizzaMenuCorsi
     * @param bool $visualizzaMenuPresenze
     * @param bool $visualizzaMenuTurni
     */
    public function __construct($anagrafeModifica = null, IntegrazioneCupMisericordie $cupMisericordie = null, IntegrazioneCupSubito $cupSubito = null, $disabilitaControlloScadenzaQualifiche = null, $eVENTI_IntervalloGiorni = null, $eVENTI_SelezioneManualeAttivita = null, $eVENTI_VincolaSezione = null, ArrayOfMezzo_Model $mezzi = null, ArrayOfRichiestaCartellino_Motivo $motiviRichiestaCartellino = null, $pRESENZE_TipoControllo = null, $profilo_CaricaImmagine = null, $profilo_RicaricaImmagine = null, $segnalaGuasti = null, $segnalaGuastiMezzo = null, ArrayOfSezione $sezioni = null, ArrayOfSezione_Model $sezioni2 = null, $tURNI_IntervalloGiorni = null, $tURNI_MostraSiglaMezzo = null, $tURNI_SelezioneManualeAttivita = null, ArrayOfTipoRecapito $tipiRecapito = null, $utenteAmministratore = null, $visualizzaMenuAnagrafe = null, $visualizzaMenuCorsi = null, $visualizzaMenuPresenze = null, $visualizzaMenuTurni = null)
    {
        $this
            ->setAnagrafeModifica($anagrafeModifica)
            ->setCupMisericordie($cupMisericordie)
            ->setCupSubito($cupSubito)
            ->setDisabilitaControlloScadenzaQualifiche($disabilitaControlloScadenzaQualifiche)
            ->setEVENTI_IntervalloGiorni($eVENTI_IntervalloGiorni)
            ->setEVENTI_SelezioneManualeAttivita($eVENTI_SelezioneManualeAttivita)
            ->setEVENTI_VincolaSezione($eVENTI_VincolaSezione)
            ->setMezzi($mezzi)
            ->setMotiviRichiestaCartellino($motiviRichiestaCartellino)
            ->setPRESENZE_TipoControllo($pRESENZE_TipoControllo)
            ->setProfilo_CaricaImmagine($profilo_CaricaImmagine)
            ->setProfilo_RicaricaImmagine($profilo_RicaricaImmagine)
            ->setSegnalaGuasti($segnalaGuasti)
            ->setSegnalaGuastiMezzo($segnalaGuastiMezzo)
            ->setSezioni($sezioni)
            ->setSezioni2($sezioni2)
            ->setTURNI_IntervalloGiorni($tURNI_IntervalloGiorni)
            ->setTURNI_MostraSiglaMezzo($tURNI_MostraSiglaMezzo)
            ->setTURNI_SelezioneManualeAttivita($tURNI_SelezioneManualeAttivita)
            ->setTipiRecapito($tipiRecapito)
            ->setUtenteAmministratore($utenteAmministratore)
            ->setVisualizzaMenuAnagrafe($visualizzaMenuAnagrafe)
            ->setVisualizzaMenuCorsi($visualizzaMenuCorsi)
            ->setVisualizzaMenuPresenze($visualizzaMenuPresenze)
            ->setVisualizzaMenuTurni($visualizzaMenuTurni);
    }
    /**
     * Get AnagrafeModifica value
     * @return bool|null
     */
    public function getAnagrafeModifica()
    {
        return $this->AnagrafeModifica;
    }
    /**
     * Set AnagrafeModifica value
     * @param bool $anagrafeModifica
     * @return Configurazione
     */
    public function setAnagrafeModifica($anagrafeModifica = null)
    {
        // validation for constraint: boolean
        if (!is_null($anagrafeModifica) && !is_bool($anagrafeModifica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($anagrafeModifica, true), gettype($anagrafeModifica)), __LINE__);
        }
        $this->AnagrafeModifica = $anagrafeModifica;
        return $this;
    }
    /**
     * Get CupMisericordie value
     * @return IntegrazioneCupMisericordie|null
     */
    public function getCupMisericordie()
    {
        return $this->CupMisericordie;
    }
    /**
     * Set CupMisericordie value
     * @param IntegrazioneCupMisericordie $cupMisericordie
     * @return Configurazione
     */
    public function setCupMisericordie(IntegrazioneCupMisericordie $cupMisericordie = null)
    {
        $this->CupMisericordie = $cupMisericordie;
        return $this;
    }
    /**
     * Get CupSubito value
     * @return IntegrazioneCupSubito|null
     */
    public function getCupSubito()
    {
        return $this->CupSubito;
    }
    /**
     * Set CupSubito value
     * @param IntegrazioneCupSubito $cupSubito
     * @return Configurazione
     */
    public function setCupSubito(IntegrazioneCupSubito $cupSubito = null)
    {
        $this->CupSubito = $cupSubito;
        return $this;
    }
    /**
     * Get DisabilitaControlloScadenzaQualifiche value
     * @return bool|null
     */
    public function getDisabilitaControlloScadenzaQualifiche()
    {
        return $this->DisabilitaControlloScadenzaQualifiche;
    }
    /**
     * Set DisabilitaControlloScadenzaQualifiche value
     * @param bool $disabilitaControlloScadenzaQualifiche
     * @return Configurazione
     */
    public function setDisabilitaControlloScadenzaQualifiche($disabilitaControlloScadenzaQualifiche = null)
    {
        // validation for constraint: boolean
        if (!is_null($disabilitaControlloScadenzaQualifiche) && !is_bool($disabilitaControlloScadenzaQualifiche)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($disabilitaControlloScadenzaQualifiche, true), gettype($disabilitaControlloScadenzaQualifiche)), __LINE__);
        }
        $this->DisabilitaControlloScadenzaQualifiche = $disabilitaControlloScadenzaQualifiche;
        return $this;
    }
    /**
     * Get EVENTI_IntervalloGiorni value
     * @return int|null
     */
    public function getEVENTI_IntervalloGiorni()
    {
        return $this->EVENTI_IntervalloGiorni;
    }
    /**
     * Set EVENTI_IntervalloGiorni value
     * @param int $eVENTI_IntervalloGiorni
     * @return Configurazione
     */
    public function setEVENTI_IntervalloGiorni($eVENTI_IntervalloGiorni = null)
    {
        // validation for constraint: int
        if (!is_null($eVENTI_IntervalloGiorni) && !(is_int($eVENTI_IntervalloGiorni) || ctype_digit($eVENTI_IntervalloGiorni))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eVENTI_IntervalloGiorni, true), gettype($eVENTI_IntervalloGiorni)), __LINE__);
        }
        $this->EVENTI_IntervalloGiorni = $eVENTI_IntervalloGiorni;
        return $this;
    }
    /**
     * Get EVENTI_SelezioneManualeAttivita value
     * @return bool|null
     */
    public function getEVENTI_SelezioneManualeAttivita()
    {
        return $this->EVENTI_SelezioneManualeAttivita;
    }
    /**
     * Set EVENTI_SelezioneManualeAttivita value
     * @param bool $eVENTI_SelezioneManualeAttivita
     * @return Configurazione
     */
    public function setEVENTI_SelezioneManualeAttivita($eVENTI_SelezioneManualeAttivita = null)
    {
        // validation for constraint: boolean
        if (!is_null($eVENTI_SelezioneManualeAttivita) && !is_bool($eVENTI_SelezioneManualeAttivita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eVENTI_SelezioneManualeAttivita, true), gettype($eVENTI_SelezioneManualeAttivita)), __LINE__);
        }
        $this->EVENTI_SelezioneManualeAttivita = $eVENTI_SelezioneManualeAttivita;
        return $this;
    }
    /**
     * Get EVENTI_VincolaSezione value
     * @return bool|null
     */
    public function getEVENTI_VincolaSezione()
    {
        return $this->EVENTI_VincolaSezione;
    }
    /**
     * Set EVENTI_VincolaSezione value
     * @param bool $eVENTI_VincolaSezione
     * @return Configurazione
     */
    public function setEVENTI_VincolaSezione($eVENTI_VincolaSezione = null)
    {
        // validation for constraint: boolean
        if (!is_null($eVENTI_VincolaSezione) && !is_bool($eVENTI_VincolaSezione)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($eVENTI_VincolaSezione, true), gettype($eVENTI_VincolaSezione)), __LINE__);
        }
        $this->EVENTI_VincolaSezione = $eVENTI_VincolaSezione;
        return $this;
    }
    /**
     * Get Mezzi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfMezzo_Model|null
     */
    public function getMezzi()
    {
        return isset($this->Mezzi) ? $this->Mezzi : null;
    }
    /**
     * Set Mezzi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfMezzo_Model $mezzi
     * @return Configurazione
     */
    public function setMezzi(ArrayOfMezzo_Model $mezzi = null)
    {
        if (is_null($mezzi) || (is_array($mezzi) && empty($mezzi))) {
            unset($this->Mezzi);
        } else {
            $this->Mezzi = $mezzi;
        }
        return $this;
    }
    /**
     * Get MotiviRichiestaCartellino value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfRichiestaCartellino_Motivo|null
     */
    public function getMotiviRichiestaCartellino()
    {
        return isset($this->MotiviRichiestaCartellino) ? $this->MotiviRichiestaCartellino : null;
    }
    /**
     * Set MotiviRichiestaCartellino value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfRichiestaCartellino_Motivo $motiviRichiestaCartellino
     * @return Configurazione
     */
    public function setMotiviRichiestaCartellino(ArrayOfRichiestaCartellino_Motivo $motiviRichiestaCartellino = null)
    {
        if (is_null($motiviRichiestaCartellino) || (is_array($motiviRichiestaCartellino) && empty($motiviRichiestaCartellino))) {
            unset($this->MotiviRichiestaCartellino);
        } else {
            $this->MotiviRichiestaCartellino = $motiviRichiestaCartellino;
        }
        return $this;
    }
    /**
     * Get PRESENZE_TipoControllo value
     * @return string|null
     */
    public function getPRESENZE_TipoControllo()
    {
        return $this->PRESENZE_TipoControllo;
    }
    /**
     * Set PRESENZE_TipoControllo value
     * @uses PRESENZE_TipoControllo::valueIsValid()
     * @uses PRESENZE_TipoControllo::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pRESENZE_TipoControllo
     * @return Configurazione
     */
    public function setPRESENZE_TipoControllo($pRESENZE_TipoControllo = null)
    {
        // validation for constraint: enumeration
        if (!PRESENZE_TipoControllo::valueIsValid($pRESENZE_TipoControllo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class PRESENZE_TipoControllo', is_array($pRESENZE_TipoControllo) ? implode(', ', $pRESENZE_TipoControllo) : var_export($pRESENZE_TipoControllo, true), implode(', ', PRESENZE_TipoControllo::getValidValues())), __LINE__);
        }
        $this->PRESENZE_TipoControllo = $pRESENZE_TipoControllo;
        return $this;
    }
    /**
     * Get Profilo_CaricaImmagine value
     * @return bool|null
     */
    public function getProfilo_CaricaImmagine()
    {
        return $this->Profilo_CaricaImmagine;
    }
    /**
     * Set Profilo_CaricaImmagine value
     * @param bool $profilo_CaricaImmagine
     * @return Configurazione
     */
    public function setProfilo_CaricaImmagine($profilo_CaricaImmagine = null)
    {
        // validation for constraint: boolean
        if (!is_null($profilo_CaricaImmagine) && !is_bool($profilo_CaricaImmagine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($profilo_CaricaImmagine, true), gettype($profilo_CaricaImmagine)), __LINE__);
        }
        $this->Profilo_CaricaImmagine = $profilo_CaricaImmagine;
        return $this;
    }
    /**
     * Get Profilo_RicaricaImmagine value
     * @return bool|null
     */
    public function getProfilo_RicaricaImmagine()
    {
        return $this->Profilo_RicaricaImmagine;
    }
    /**
     * Set Profilo_RicaricaImmagine value
     * @param bool $profilo_RicaricaImmagine
     * @return Configurazione
     */
    public function setProfilo_RicaricaImmagine($profilo_RicaricaImmagine = null)
    {
        // validation for constraint: boolean
        if (!is_null($profilo_RicaricaImmagine) && !is_bool($profilo_RicaricaImmagine)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($profilo_RicaricaImmagine, true), gettype($profilo_RicaricaImmagine)), __LINE__);
        }
        $this->Profilo_RicaricaImmagine = $profilo_RicaricaImmagine;
        return $this;
    }
    /**
     * Get SegnalaGuasti value
     * @return bool|null
     */
    public function getSegnalaGuasti()
    {
        return $this->SegnalaGuasti;
    }
    /**
     * Set SegnalaGuasti value
     * @param bool $segnalaGuasti
     * @return Configurazione
     */
    public function setSegnalaGuasti($segnalaGuasti = null)
    {
        // validation for constraint: boolean
        if (!is_null($segnalaGuasti) && !is_bool($segnalaGuasti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($segnalaGuasti, true), gettype($segnalaGuasti)), __LINE__);
        }
        $this->SegnalaGuasti = $segnalaGuasti;
        return $this;
    }
    /**
     * Get SegnalaGuastiMezzo value
     * @return bool|null
     */
    public function getSegnalaGuastiMezzo()
    {
        return $this->SegnalaGuastiMezzo;
    }
    /**
     * Set SegnalaGuastiMezzo value
     * @param bool $segnalaGuastiMezzo
     * @return Configurazione
     */
    public function setSegnalaGuastiMezzo($segnalaGuastiMezzo = null)
    {
        // validation for constraint: boolean
        if (!is_null($segnalaGuastiMezzo) && !is_bool($segnalaGuastiMezzo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($segnalaGuastiMezzo, true), gettype($segnalaGuastiMezzo)), __LINE__);
        }
        $this->SegnalaGuastiMezzo = $segnalaGuastiMezzo;
        return $this;
    }
    /**
     * Get Sezioni value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfSezione|null
     */
    public function getSezioni()
    {
        return isset($this->Sezioni) ? $this->Sezioni : null;
    }
    /**
     * Set Sezioni value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfSezione $sezioni
     * @return Configurazione
     */
    public function setSezioni(ArrayOfSezione $sezioni = null)
    {
        if (is_null($sezioni) || (is_array($sezioni) && empty($sezioni))) {
            unset($this->Sezioni);
        } else {
            $this->Sezioni = $sezioni;
        }
        return $this;
    }
    /**
     * Get Sezioni2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfSezione_Model|null
     */
    public function getSezioni2()
    {
        return isset($this->Sezioni2) ? $this->Sezioni2 : null;
    }
    /**
     * Set Sezioni2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfSezione_Model $sezioni2
     * @return Configurazione
     */
    public function setSezioni2(ArrayOfSezione_Model $sezioni2 = null)
    {
        if (is_null($sezioni2) || (is_array($sezioni2) && empty($sezioni2))) {
            unset($this->Sezioni2);
        } else {
            $this->Sezioni2 = $sezioni2;
        }
        return $this;
    }
    /**
     * Get TURNI_IntervalloGiorni value
     * @return int|null
     */
    public function getTURNI_IntervalloGiorni()
    {
        return $this->TURNI_IntervalloGiorni;
    }
    /**
     * Set TURNI_IntervalloGiorni value
     * @param int $tURNI_IntervalloGiorni
     * @return Configurazione
     */
    public function setTURNI_IntervalloGiorni($tURNI_IntervalloGiorni = null)
    {
        // validation for constraint: int
        if (!is_null($tURNI_IntervalloGiorni) && !(is_int($tURNI_IntervalloGiorni) || ctype_digit($tURNI_IntervalloGiorni))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tURNI_IntervalloGiorni, true), gettype($tURNI_IntervalloGiorni)), __LINE__);
        }
        $this->TURNI_IntervalloGiorni = $tURNI_IntervalloGiorni;
        return $this;
    }
    /**
     * Get TURNI_MostraSiglaMezzo value
     * @return bool|null
     */
    public function getTURNI_MostraSiglaMezzo()
    {
        return $this->TURNI_MostraSiglaMezzo;
    }
    /**
     * Set TURNI_MostraSiglaMezzo value
     * @param bool $tURNI_MostraSiglaMezzo
     * @return Configurazione
     */
    public function setTURNI_MostraSiglaMezzo($tURNI_MostraSiglaMezzo = null)
    {
        // validation for constraint: boolean
        if (!is_null($tURNI_MostraSiglaMezzo) && !is_bool($tURNI_MostraSiglaMezzo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tURNI_MostraSiglaMezzo, true), gettype($tURNI_MostraSiglaMezzo)), __LINE__);
        }
        $this->TURNI_MostraSiglaMezzo = $tURNI_MostraSiglaMezzo;
        return $this;
    }
    /**
     * Get TURNI_SelezioneManualeAttivita value
     * @return bool|null
     */
    public function getTURNI_SelezioneManualeAttivita()
    {
        return $this->TURNI_SelezioneManualeAttivita;
    }
    /**
     * Set TURNI_SelezioneManualeAttivita value
     * @param bool $tURNI_SelezioneManualeAttivita
     * @return Configurazione
     */
    public function setTURNI_SelezioneManualeAttivita($tURNI_SelezioneManualeAttivita = null)
    {
        // validation for constraint: boolean
        if (!is_null($tURNI_SelezioneManualeAttivita) && !is_bool($tURNI_SelezioneManualeAttivita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($tURNI_SelezioneManualeAttivita, true), gettype($tURNI_SelezioneManualeAttivita)), __LINE__);
        }
        $this->TURNI_SelezioneManualeAttivita = $tURNI_SelezioneManualeAttivita;
        return $this;
    }
    /**
     * Get TipiRecapito value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return ArrayOfTipoRecapito|null
     */
    public function getTipiRecapito()
    {
        return isset($this->TipiRecapito) ? $this->TipiRecapito : null;
    }
    /**
     * Set TipiRecapito value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param ArrayOfTipoRecapito $tipiRecapito
     * @return Configurazione
     */
    public function setTipiRecapito(ArrayOfTipoRecapito $tipiRecapito = null)
    {
        if (is_null($tipiRecapito) || (is_array($tipiRecapito) && empty($tipiRecapito))) {
            unset($this->TipiRecapito);
        } else {
            $this->TipiRecapito = $tipiRecapito;
        }
        return $this;
    }
    /**
     * Get UtenteAmministratore value
     * @return bool|null
     */
    public function getUtenteAmministratore()
    {
        return $this->UtenteAmministratore;
    }
    /**
     * Set UtenteAmministratore value
     * @param bool $utenteAmministratore
     * @return Configurazione
     */
    public function setUtenteAmministratore($utenteAmministratore = null)
    {
        // validation for constraint: boolean
        if (!is_null($utenteAmministratore) && !is_bool($utenteAmministratore)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($utenteAmministratore, true), gettype($utenteAmministratore)), __LINE__);
        }
        $this->UtenteAmministratore = $utenteAmministratore;
        return $this;
    }
    /**
     * Get VisualizzaMenuAnagrafe value
     * @return bool|null
     */
    public function getVisualizzaMenuAnagrafe()
    {
        return $this->VisualizzaMenuAnagrafe;
    }
    /**
     * Set VisualizzaMenuAnagrafe value
     * @param bool $visualizzaMenuAnagrafe
     * @return Configurazione
     */
    public function setVisualizzaMenuAnagrafe($visualizzaMenuAnagrafe = null)
    {
        // validation for constraint: boolean
        if (!is_null($visualizzaMenuAnagrafe) && !is_bool($visualizzaMenuAnagrafe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visualizzaMenuAnagrafe, true), gettype($visualizzaMenuAnagrafe)), __LINE__);
        }
        $this->VisualizzaMenuAnagrafe = $visualizzaMenuAnagrafe;
        return $this;
    }
    /**
     * Get VisualizzaMenuCorsi value
     * @return bool|null
     */
    public function getVisualizzaMenuCorsi()
    {
        return $this->VisualizzaMenuCorsi;
    }
    /**
     * Set VisualizzaMenuCorsi value
     * @param bool $visualizzaMenuCorsi
     * @return Configurazione
     */
    public function setVisualizzaMenuCorsi($visualizzaMenuCorsi = null)
    {
        // validation for constraint: boolean
        if (!is_null($visualizzaMenuCorsi) && !is_bool($visualizzaMenuCorsi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visualizzaMenuCorsi, true), gettype($visualizzaMenuCorsi)), __LINE__);
        }
        $this->VisualizzaMenuCorsi = $visualizzaMenuCorsi;
        return $this;
    }
    /**
     * Get VisualizzaMenuPresenze value
     * @return bool|null
     */
    public function getVisualizzaMenuPresenze()
    {
        return $this->VisualizzaMenuPresenze;
    }
    /**
     * Set VisualizzaMenuPresenze value
     * @param bool $visualizzaMenuPresenze
     * @return Configurazione
     */
    public function setVisualizzaMenuPresenze($visualizzaMenuPresenze = null)
    {
        // validation for constraint: boolean
        if (!is_null($visualizzaMenuPresenze) && !is_bool($visualizzaMenuPresenze)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visualizzaMenuPresenze, true), gettype($visualizzaMenuPresenze)), __LINE__);
        }
        $this->VisualizzaMenuPresenze = $visualizzaMenuPresenze;
        return $this;
    }
    /**
     * Get VisualizzaMenuTurni value
     * @return bool|null
     */
    public function getVisualizzaMenuTurni()
    {
        return $this->VisualizzaMenuTurni;
    }
    /**
     * Set VisualizzaMenuTurni value
     * @param bool $visualizzaMenuTurni
     * @return Configurazione
     */
    public function setVisualizzaMenuTurni($visualizzaMenuTurni = null)
    {
        // validation for constraint: boolean
        if (!is_null($visualizzaMenuTurni) && !is_bool($visualizzaMenuTurni)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visualizzaMenuTurni, true), gettype($visualizzaMenuTurni)), __LINE__);
        }
        $this->VisualizzaMenuTurni = $visualizzaMenuTurni;
        return $this;
    }
}
