<?php
use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Anagrafica_Model StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Anagrafica_Model
 * @subpackage Structs
 */
class Anagrafica_Model extends AbstractStructBase
{
    /**
     * The Cognome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Cognome;
    /**
     * The DataDiNascita
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataDiNascita;
    /**
     * The ID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The Nome
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Nome;
    /**
     * The Sesso
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Sesso;
    /**
     * The Socio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var Socio_Model
     */
    public $Socio;
    /**
     * The Volontario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var Volontario_Model
     */
    public $Volontario;
    /**
     * Constructor method for Anagrafica_Model
     * @uses Anagrafica_Model::setCognome()
     * @uses Anagrafica_Model::setDataDiNascita()
     * @uses Anagrafica_Model::setID()
     * @uses Anagrafica_Model::setNome()
     * @uses Anagrafica_Model::setSesso()
     * @uses Anagrafica_Model::setSocio()
     * @uses Anagrafica_Model::setVolontario()
     * @param string $cognome
     * @param string $dataDiNascita
     * @param int $iD
     * @param string $nome
     * @param string $sesso
     * @param Socio_Model $socio
     * @param Volontario_Model $volontario
     */
    public function __construct($cognome = null, $dataDiNascita = null, $iD = null, $nome = null, $sesso = null, Socio_Model $socio = null, Volontario_Model $volontario = null)
    {
        $this
            ->setCognome($cognome)
            ->setDataDiNascita($dataDiNascita)
            ->setID($iD)
            ->setNome($nome)
            ->setSesso($sesso)
            ->setSocio($socio)
            ->setVolontario($volontario);
    }
    /**
     * Get Cognome value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCognome()
    {
        return isset($this->Cognome) ? $this->Cognome : null;
    }
    /**
     * Set Cognome value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cognome
     * @return Anagrafica_Model
     */
    public function setCognome($cognome = null)
    {
        // validation for constraint: string
        if (!is_null($cognome) && !is_string($cognome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cognome, true), gettype($cognome)), __LINE__);
        }
        if (is_null($cognome) || (is_array($cognome) && empty($cognome))) {
            unset($this->Cognome);
        } else {
            $this->Cognome = $cognome;
        }
        return $this;
    }
    /**
     * Get DataDiNascita value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataDiNascita()
    {
        return isset($this->DataDiNascita) ? $this->DataDiNascita : null;
    }
    /**
     * Set DataDiNascita value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataDiNascita
     * @return Anagrafica_Model
     */
    public function setDataDiNascita($dataDiNascita = null)
    {
        // validation for constraint: string
        if (!is_null($dataDiNascita) && !is_string($dataDiNascita)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataDiNascita, true), gettype($dataDiNascita)), __LINE__);
        }
        if (is_null($dataDiNascita) || (is_array($dataDiNascita) && empty($dataDiNascita))) {
            unset($this->DataDiNascita);
        } else {
            $this->DataDiNascita = $dataDiNascita;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return Anagrafica_Model
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !(is_int($iD) || ctype_digit($iD))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($iD, true), gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Nome value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNome()
    {
        return isset($this->Nome) ? $this->Nome : null;
    }
    /**
     * Set Nome value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nome
     * @return Anagrafica_Model
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nome, true), gettype($nome)), __LINE__);
        }
        if (is_null($nome) || (is_array($nome) && empty($nome))) {
            unset($this->Nome);
        } else {
            $this->Nome = $nome;
        }
        return $this;
    }
    /**
     * Get Sesso value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSesso()
    {
        return isset($this->Sesso) ? $this->Sesso : null;
    }
    /**
     * Set Sesso value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sesso
     * @return Anagrafica_Model
     */
    public function setSesso($sesso = null)
    {
        // validation for constraint: string
        if (!is_null($sesso) && !is_string($sesso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sesso, true), gettype($sesso)), __LINE__);
        }
        if (is_null($sesso) || (is_array($sesso) && empty($sesso))) {
            unset($this->Sesso);
        } else {
            $this->Sesso = $sesso;
        }
        return $this;
    }
    /**
     * Get Socio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return Socio_Model|null
     */
    public function getSocio()
    {
        return isset($this->Socio) ? $this->Socio : null;
    }
    /**
     * Set Socio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param Socio_Model $socio
     * @return Anagrafica_Model
     */
    public function setSocio(Socio_Model $socio = null)
    {
        if (is_null($socio) || (is_array($socio) && empty($socio))) {
            unset($this->Socio);
        } else {
            $this->Socio = $socio;
        }
        return $this;
    }
    /**
     * Get Volontario value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return Volontario_Model|null
     */
    public function getVolontario()
    {
        return isset($this->Volontario) ? $this->Volontario : null;
    }
    /**
     * Set Volontario value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param Volontario_Model $volontario
     * @return Anagrafica_Model
     */
    public function setVolontario(Volontario_Model $volontario = null)
    {
        if (is_null($volontario) || (is_array($volontario) && empty($volontario))) {
            unset($this->Volontario);
        } else {
            $this->Volontario = $volontario;
        }
        return $this;
    }
}
