<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Salva ServiceType
 * @subpackage Services
 */
class Salva extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named SalvaRecapito
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SalvaRecapito $parameters
     * @return \StructType\SalvaRecapitoResponse|bool
     */
    public function SalvaRecapito(\StructType\SalvaRecapito $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SalvaRecapito($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SalvaAnagrafe
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\SalvaAnagrafe $parameters
     * @return \StructType\SalvaAnagrafeResponse|bool
     */
    public function SalvaAnagrafe(\StructType\SalvaAnagrafe $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->SalvaAnagrafe($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\SalvaAnagrafeResponse|\StructType\SalvaRecapitoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
