<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfQualifica ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfQualifica
 * @subpackage Arrays
 */
class ArrayOfQualifica extends AbstractStructArrayBase
{
    /**
     * The Qualifica
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Qualifica[]
     */
    public $Qualifica;
    /**
     * Constructor method for ArrayOfQualifica
     * @uses ArrayOfQualifica::setQualifica()
     * @param \StructType\Qualifica[] $qualifica
     */
    public function __construct(array $qualifica = array())
    {
        $this
            ->setQualifica($qualifica);
    }
    /**
     * Get Qualifica value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Qualifica[]|null
     */
    public function getQualifica()
    {
        return isset($this->Qualifica) ? $this->Qualifica : null;
    }
    /**
     * This method is responsible for validating the values passed to the setQualifica method
     * This method is willingly generated in order to preserve the one-line inline validation within the setQualifica method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateQualificaForArrayConstraintsFromSetQualifica(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfQualificaQualificaItem) {
            // validation for constraint: itemType
            if (!$arrayOfQualificaQualificaItem instanceof \StructType\Qualifica) {
                $invalidValues[] = is_object($arrayOfQualificaQualificaItem) ? get_class($arrayOfQualificaQualificaItem) : sprintf('%s(%s)', gettype($arrayOfQualificaQualificaItem), var_export($arrayOfQualificaQualificaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Qualifica property can only contain items of type \StructType\Qualifica, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Qualifica value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Qualifica[] $qualifica
     * @return \ArrayType\ArrayOfQualifica
     */
    public function setQualifica(array $qualifica = array())
    {
        // validation for constraint: array
        if ('' !== ($qualificaArrayErrorMessage = self::validateQualificaForArrayConstraintsFromSetQualifica($qualifica))) {
            throw new \InvalidArgumentException($qualificaArrayErrorMessage, __LINE__);
        }
        if (is_null($qualifica) || (is_array($qualifica) && empty($qualifica))) {
            unset($this->Qualifica);
        } else {
            $this->Qualifica = $qualifica;
        }
        return $this;
    }
    /**
     * Add item to Qualifica value
     * @throws \InvalidArgumentException
     * @param \StructType\Qualifica $item
     * @return \ArrayType\ArrayOfQualifica
     */
    public function addToQualifica(\StructType\Qualifica $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Qualifica) {
            throw new \InvalidArgumentException(sprintf('The Qualifica property can only contain items of type \StructType\Qualifica, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Qualifica[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Qualifica|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Qualifica|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Qualifica|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Qualifica|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Qualifica|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Qualifica
     */
    public function getAttributeName()
    {
        return 'Qualifica';
    }
}
