<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Login_SGEServer_Result StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Login_SGEServer_Result
 * @subpackage Structs
 */
class Login_SGEServer_Result extends AbstractStructBase
{
    /**
     * The AuthToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthToken;
    /**
     * The ClasseNuoviSoci
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Classe_Model
     */
    public $ClasseNuoviSoci;
    /**
     * The ClasseRiattivazioneSoci
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Classe_Model
     */
    public $ClasseRiattivazioneSoci;
    /**
     * The Informazioni
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\AdditionaInformation
     */
    public $Informazioni;
    /**
     * The Province
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfProvincia_Model
     */
    public $Province;
    /**
     * The TipiRecpito
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfTipoRecapito
     */
    public $TipiRecpito;
    /**
     * Constructor method for Login_SGEServer_Result
     * @uses Login_SGEServer_Result::setAuthToken()
     * @uses Login_SGEServer_Result::setClasseNuoviSoci()
     * @uses Login_SGEServer_Result::setClasseRiattivazioneSoci()
     * @uses Login_SGEServer_Result::setInformazioni()
     * @uses Login_SGEServer_Result::setProvince()
     * @uses Login_SGEServer_Result::setTipiRecpito()
     * @param string $authToken
     * @param \StructType\Classe_Model $classeNuoviSoci
     * @param \StructType\Classe_Model $classeRiattivazioneSoci
     * @param \StructType\AdditionaInformation $informazioni
     * @param \ArrayType\ArrayOfProvincia_Model $province
     * @param \ArrayType\ArrayOfTipoRecapito $tipiRecpito
     */
    public function __construct($authToken = null, \StructType\Classe_Model $classeNuoviSoci = null, \StructType\Classe_Model $classeRiattivazioneSoci = null, \StructType\AdditionaInformation $informazioni = null, \ArrayType\ArrayOfProvincia_Model $province = null, \ArrayType\ArrayOfTipoRecapito $tipiRecpito = null)
    {
        $this
            ->setAuthToken($authToken)
            ->setClasseNuoviSoci($classeNuoviSoci)
            ->setClasseRiattivazioneSoci($classeRiattivazioneSoci)
            ->setInformazioni($informazioni)
            ->setProvince($province)
            ->setTipiRecpito($tipiRecpito);
    }
    /**
     * Get AuthToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthToken()
    {
        return isset($this->AuthToken) ? $this->AuthToken : null;
    }
    /**
     * Set AuthToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authToken
     * @return \StructType\Login_SGEServer_Result
     */
    public function setAuthToken($authToken = null)
    {
        // validation for constraint: string
        if (!is_null($authToken) && !is_string($authToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authToken, true), gettype($authToken)), __LINE__);
        }
        if (is_null($authToken) || (is_array($authToken) && empty($authToken))) {
            unset($this->AuthToken);
        } else {
            $this->AuthToken = $authToken;
        }
        return $this;
    }
    /**
     * Get ClasseNuoviSoci value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Classe_Model|null
     */
    public function getClasseNuoviSoci()
    {
        return isset($this->ClasseNuoviSoci) ? $this->ClasseNuoviSoci : null;
    }
    /**
     * Set ClasseNuoviSoci value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Classe_Model $classeNuoviSoci
     * @return \StructType\Login_SGEServer_Result
     */
    public function setClasseNuoviSoci(\StructType\Classe_Model $classeNuoviSoci = null)
    {
        if (is_null($classeNuoviSoci) || (is_array($classeNuoviSoci) && empty($classeNuoviSoci))) {
            unset($this->ClasseNuoviSoci);
        } else {
            $this->ClasseNuoviSoci = $classeNuoviSoci;
        }
        return $this;
    }
    /**
     * Get ClasseRiattivazioneSoci value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Classe_Model|null
     */
    public function getClasseRiattivazioneSoci()
    {
        return isset($this->ClasseRiattivazioneSoci) ? $this->ClasseRiattivazioneSoci : null;
    }
    /**
     * Set ClasseRiattivazioneSoci value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\Classe_Model $classeRiattivazioneSoci
     * @return \StructType\Login_SGEServer_Result
     */
    public function setClasseRiattivazioneSoci(\StructType\Classe_Model $classeRiattivazioneSoci = null)
    {
        if (is_null($classeRiattivazioneSoci) || (is_array($classeRiattivazioneSoci) && empty($classeRiattivazioneSoci))) {
            unset($this->ClasseRiattivazioneSoci);
        } else {
            $this->ClasseRiattivazioneSoci = $classeRiattivazioneSoci;
        }
        return $this;
    }
    /**
     * Get Informazioni value
     * @return \StructType\AdditionaInformation|null
     */
    public function getInformazioni()
    {
        return $this->Informazioni;
    }
    /**
     * Set Informazioni value
     * @param \StructType\AdditionaInformation $informazioni
     * @return \StructType\Login_SGEServer_Result
     */
    public function setInformazioni(\StructType\AdditionaInformation $informazioni = null)
    {
        $this->Informazioni = $informazioni;
        return $this;
    }
    /**
     * Get Province value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfProvincia_Model|null
     */
    public function getProvince()
    {
        return isset($this->Province) ? $this->Province : null;
    }
    /**
     * Set Province value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfProvincia_Model $province
     * @return \StructType\Login_SGEServer_Result
     */
    public function setProvince(\ArrayType\ArrayOfProvincia_Model $province = null)
    {
        if (is_null($province) || (is_array($province) && empty($province))) {
            unset($this->Province);
        } else {
            $this->Province = $province;
        }
        return $this;
    }
    /**
     * Get TipiRecpito value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfTipoRecapito|null
     */
    public function getTipiRecpito()
    {
        return isset($this->TipiRecpito) ? $this->TipiRecpito : null;
    }
    /**
     * Set TipiRecpito value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfTipoRecapito $tipiRecpito
     * @return \StructType\Login_SGEServer_Result
     */
    public function setTipiRecpito(\ArrayType\ArrayOfTipoRecapito $tipiRecpito = null)
    {
        if (is_null($tipiRecpito) || (is_array($tipiRecpito) && empty($tipiRecpito))) {
            unset($this->TipiRecpito);
        } else {
            $this->TipiRecpito = $tipiRecpito;
        }
        return $this;
    }
}
