<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AdditionaInformation StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AdditionaInformation
 * @subpackage Structs
 */
class AdditionaInformation extends AbstractStructBase
{
    /**
     * The InfoMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InfoMessage;
    /**
     * The Result
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Result;
    /**
     * Constructor method for AdditionaInformation
     * @uses AdditionaInformation::setInfoMessage()
     * @uses AdditionaInformation::setResult()
     * @param string $infoMessage
     * @param bool $result
     */
    public function __construct($infoMessage = null, $result = null)
    {
        $this
            ->setInfoMessage($infoMessage)
            ->setResult($result);
    }
    /**
     * Get InfoMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInfoMessage()
    {
        return isset($this->InfoMessage) ? $this->InfoMessage : null;
    }
    /**
     * Set InfoMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $infoMessage
     * @return \StructType\AdditionaInformation
     */
    public function setInfoMessage($infoMessage = null)
    {
        // validation for constraint: string
        if (!is_null($infoMessage) && !is_string($infoMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($infoMessage, true), gettype($infoMessage)), __LINE__);
        }
        if (is_null($infoMessage) || (is_array($infoMessage) && empty($infoMessage))) {
            unset($this->InfoMessage);
        } else {
            $this->InfoMessage = $infoMessage;
        }
        return $this;
    }
    /**
     * Get Result value
     * @return bool|null
     */
    public function getResult()
    {
        return $this->Result;
    }
    /**
     * Set Result value
     * @param bool $result
     * @return \StructType\AdditionaInformation
     */
    public function setResult($result = null)
    {
        // validation for constraint: boolean
        if (!is_null($result) && !is_bool($result)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($result, true), gettype($result)), __LINE__);
        }
        $this->Result = $result;
        return $this;
    }
}
