<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Rinnova ServiceType
 * @subpackage Services
 */
class Rinnova extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named RinnovaPrivacy
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RinnovaPrivacy $parameters
     * @return \StructType\RinnovaPrivacyResponse|bool
     */
    public function RinnovaPrivacy(\StructType\RinnovaPrivacy $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->RinnovaPrivacy($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RinnovaPrivacyResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
