<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddFiyatAlarmUrunRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddFiyatAlarmUrunRequest
 * @subpackage Structs
 */
class AddFiyatAlarmUrunRequest extends AbstractStructBase
{
    /**
     * The Fiyat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Fiyat;
    /**
     * The UrunKartiID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UrunKartiID;
    /**
     * The UyeID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $UyeID;
    /**
     * Constructor method for AddFiyatAlarmUrunRequest
     * @uses AddFiyatAlarmUrunRequest::setFiyat()
     * @uses AddFiyatAlarmUrunRequest::setUrunKartiID()
     * @uses AddFiyatAlarmUrunRequest::setUyeID()
     * @param float $fiyat
     * @param int $urunKartiID
     * @param int $uyeID
     */
    public function __construct($fiyat = null, $urunKartiID = null, $uyeID = null)
    {
        $this
            ->setFiyat($fiyat)
            ->setUrunKartiID($urunKartiID)
            ->setUyeID($uyeID);
    }
    /**
     * Get Fiyat value
     * @return float|null
     */
    public function getFiyat()
    {
        return $this->Fiyat;
    }
    /**
     * Set Fiyat value
     * @param float $fiyat
     * @return \StructType\AddFiyatAlarmUrunRequest
     */
    public function setFiyat($fiyat = null)
    {
        // validation for constraint: float
        if (!is_null($fiyat) && !(is_float($fiyat) || is_numeric($fiyat))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($fiyat, true), gettype($fiyat)), __LINE__);
        }
        $this->Fiyat = $fiyat;
        return $this;
    }
    /**
     * Get UrunKartiID value
     * @return int|null
     */
    public function getUrunKartiID()
    {
        return $this->UrunKartiID;
    }
    /**
     * Set UrunKartiID value
     * @param int $urunKartiID
     * @return \StructType\AddFiyatAlarmUrunRequest
     */
    public function setUrunKartiID($urunKartiID = null)
    {
        // validation for constraint: int
        if (!is_null($urunKartiID) && !(is_int($urunKartiID) || ctype_digit($urunKartiID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($urunKartiID, true), gettype($urunKartiID)), __LINE__);
        }
        $this->UrunKartiID = $urunKartiID;
        return $this;
    }
    /**
     * Get UyeID value
     * @return int|null
     */
    public function getUyeID()
    {
        return $this->UyeID;
    }
    /**
     * Set UyeID value
     * @param int $uyeID
     * @return \StructType\AddFiyatAlarmUrunRequest
     */
    public function setUyeID($uyeID = null)
    {
        // validation for constraint: int
        if (!is_null($uyeID) && !(is_int($uyeID) || ctype_digit($uyeID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($uyeID, true), gettype($uyeID)), __LINE__);
        }
        $this->UyeID = $uyeID;
        return $this;
    }
}
