<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMenuRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:GetMenuRequest
 * @subpackage Structs
 */
class GetMenuRequest extends AbstractStructBase
{
    /**
     * The Aktif
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Aktif;
    /**
     * The Dil
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Dil;
    /**
     * The MenuID
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MenuID;
    /**
     * Constructor method for GetMenuRequest
     * @uses GetMenuRequest::setAktif()
     * @uses GetMenuRequest::setDil()
     * @uses GetMenuRequest::setMenuID()
     * @param int $aktif
     * @param string $dil
     * @param int $menuID
     */
    public function __construct($aktif = null, $dil = null, $menuID = null)
    {
        $this
            ->setAktif($aktif)
            ->setDil($dil)
            ->setMenuID($menuID);
    }
    /**
     * Get Aktif value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAktif()
    {
        return isset($this->Aktif) ? $this->Aktif : null;
    }
    /**
     * Set Aktif value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aktif
     * @return \StructType\GetMenuRequest
     */
    public function setAktif($aktif = null)
    {
        // validation for constraint: int
        if (!is_null($aktif) && !(is_int($aktif) || ctype_digit($aktif))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aktif, true), gettype($aktif)), __LINE__);
        }
        if (is_null($aktif) || (is_array($aktif) && empty($aktif))) {
            unset($this->Aktif);
        } else {
            $this->Aktif = $aktif;
        }
        return $this;
    }
    /**
     * Get Dil value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDil()
    {
        return isset($this->Dil) ? $this->Dil : null;
    }
    /**
     * Set Dil value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dil
     * @return \StructType\GetMenuRequest
     */
    public function setDil($dil = null)
    {
        // validation for constraint: string
        if (!is_null($dil) && !is_string($dil)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dil, true), gettype($dil)), __LINE__);
        }
        if (is_null($dil) || (is_array($dil) && empty($dil))) {
            unset($this->Dil);
        } else {
            $this->Dil = $dil;
        }
        return $this;
    }
    /**
     * Get MenuID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMenuID()
    {
        return isset($this->MenuID) ? $this->MenuID : null;
    }
    /**
     * Set MenuID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $menuID
     * @return \StructType\GetMenuRequest
     */
    public function setMenuID($menuID = null)
    {
        // validation for constraint: int
        if (!is_null($menuID) && !(is_int($menuID) || ctype_digit($menuID))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($menuID, true), gettype($menuID)), __LINE__);
        }
        if (is_null($menuID) || (is_array($menuID) && empty($menuID))) {
            unset($this->MenuID);
        } else {
            $this->MenuID = $menuID;
        }
        return $this;
    }
}
