<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEnumKeyValue ArrayType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfEnumKeyValue
 * @subpackage Arrays
 */
class ArrayOfEnumKeyValue extends AbstractStructArrayBase
{
    /**
     * The EnumKeyValue
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EnumKeyValue[]
     */
    public $EnumKeyValue;
    /**
     * Constructor method for ArrayOfEnumKeyValue
     * @uses ArrayOfEnumKeyValue::setEnumKeyValue()
     * @param \StructType\EnumKeyValue[] $enumKeyValue
     */
    public function __construct(array $enumKeyValue = array())
    {
        $this
            ->setEnumKeyValue($enumKeyValue);
    }
    /**
     * Get EnumKeyValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EnumKeyValue[]|null
     */
    public function getEnumKeyValue()
    {
        return isset($this->EnumKeyValue) ? $this->EnumKeyValue : null;
    }
    /**
     * This method is responsible for validating the values passed to the setEnumKeyValue method
     * This method is willingly generated in order to preserve the one-line inline validation within the setEnumKeyValue method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateEnumKeyValueForArrayConstraintsFromSetEnumKeyValue(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $arrayOfEnumKeyValueEnumKeyValueItem) {
            // validation for constraint: itemType
            if (!$arrayOfEnumKeyValueEnumKeyValueItem instanceof \StructType\EnumKeyValue) {
                $invalidValues[] = is_object($arrayOfEnumKeyValueEnumKeyValueItem) ? get_class($arrayOfEnumKeyValueEnumKeyValueItem) : sprintf('%s(%s)', gettype($arrayOfEnumKeyValueEnumKeyValueItem), var_export($arrayOfEnumKeyValueEnumKeyValueItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The EnumKeyValue property can only contain items of type \StructType\EnumKeyValue, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set EnumKeyValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EnumKeyValue[] $enumKeyValue
     * @return \ArrayType\ArrayOfEnumKeyValue
     */
    public function setEnumKeyValue(array $enumKeyValue = array())
    {
        // validation for constraint: array
        if ('' !== ($enumKeyValueArrayErrorMessage = self::validateEnumKeyValueForArrayConstraintsFromSetEnumKeyValue($enumKeyValue))) {
            throw new \InvalidArgumentException($enumKeyValueArrayErrorMessage, __LINE__);
        }
        if (is_null($enumKeyValue) || (is_array($enumKeyValue) && empty($enumKeyValue))) {
            unset($this->EnumKeyValue);
        } else {
            $this->EnumKeyValue = $enumKeyValue;
        }
        return $this;
    }
    /**
     * Add item to EnumKeyValue value
     * @throws \InvalidArgumentException
     * @param \StructType\EnumKeyValue $item
     * @return \ArrayType\ArrayOfEnumKeyValue
     */
    public function addToEnumKeyValue(\StructType\EnumKeyValue $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EnumKeyValue) {
            throw new \InvalidArgumentException(sprintf('The EnumKeyValue property can only contain items of type \StructType\EnumKeyValue, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->EnumKeyValue[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EnumKeyValue|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EnumKeyValue|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EnumKeyValue|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EnumKeyValue|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EnumKeyValue|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EnumKeyValue
     */
    public function getAttributeName()
    {
        return 'EnumKeyValue';
    }
}
