<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerifyAddItemRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Enables a seller to specify the definition of a new item and submit the definition to eBay without creating a listing.&nbsp;<b>Also for Half.com</b>. <br><br> Sellers who engage in cross-border trade on sites that require a
 * recoupment agreement, must agree to the recoupment terms before adding or verifying items. This agreement allows eBay to reimburse a buyer during a dispute and then recoup the cost from the seller. The US site is a recoupment site, and the agreement
 * is located <a href="https://scgi.ebay.com/ws/eBayISAPI.dll?CBTRecoupAgreement">here</a>. The list of the sites where a user has agreed to the recoupment terms is returned by the GetUser response.
 * @subpackage Structs
 */
class VerifyAddItemRequestType extends AbstractRequestType
{
    /**
     * The Item
     * Meta informations extracted from the WSDL
     * - documentation: Root container holding all values that define a new listing.
     * - minOccurs: 0
     * @var \StructType\ItemType
     */
    public $Item;
    /**
     * The IncludeExpressRequirements
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeExpressRequirements;
    /**
     * The ExternalProductID
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \StructType\ExternalProductIDType
     */
    public $ExternalProductID;
    /**
     * Constructor method for VerifyAddItemRequestType
     * @uses VerifyAddItemRequestType::setItem()
     * @uses VerifyAddItemRequestType::setIncludeExpressRequirements()
     * @uses VerifyAddItemRequestType::setExternalProductID()
     * @param \StructType\ItemType $item
     * @param bool $includeExpressRequirements
     * @param \StructType\ExternalProductIDType $externalProductID
     */
    public function __construct(\StructType\ItemType $item = null, $includeExpressRequirements = null, \StructType\ExternalProductIDType $externalProductID = null)
    {
        $this
            ->setItem($item)
            ->setIncludeExpressRequirements($includeExpressRequirements)
            ->setExternalProductID($externalProductID);
    }
    /**
     * Get Item value
     * @return \StructType\ItemType|null
     */
    public function getItem()
    {
        return $this->Item;
    }
    /**
     * Set Item value
     * @param \StructType\ItemType $item
     * @return \StructType\VerifyAddItemRequestType
     */
    public function setItem(\StructType\ItemType $item = null)
    {
        $this->Item = $item;
        return $this;
    }
    /**
     * Get IncludeExpressRequirements value
     * @return bool|null
     */
    public function getIncludeExpressRequirements()
    {
        return $this->IncludeExpressRequirements;
    }
    /**
     * Set IncludeExpressRequirements value
     * @param bool $includeExpressRequirements
     * @return \StructType\VerifyAddItemRequestType
     */
    public function setIncludeExpressRequirements($includeExpressRequirements = null)
    {
        $this->IncludeExpressRequirements = $includeExpressRequirements;
        return $this;
    }
    /**
     * Get ExternalProductID value
     * @return \StructType\ExternalProductIDType|null
     */
    public function getExternalProductID()
    {
        return $this->ExternalProductID;
    }
    /**
     * Set ExternalProductID value
     * @param \StructType\ExternalProductIDType $externalProductID
     * @return \StructType\VerifyAddItemRequestType
     */
    public function setExternalProductID(\StructType\ExternalProductIDType $externalProductID = null)
    {
        $this->ExternalProductID = $externalProductID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VerifyAddItemRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
