<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SaveItemToSellingManagerTemplateResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Returns the status of save to template operation.
 * @subpackage Structs
 */
class SaveItemToSellingManagerTemplateResponseType extends AbstractResponseType
{
    /**
     * The TemplateID
     * Meta informations extracted from the WSDL
     * - documentation: Template ID that is newly created.
     * - minOccurs: 0
     * @var int
     */
    public $TemplateID;
    /**
     * Constructor method for SaveItemToSellingManagerTemplateResponseType
     * @uses SaveItemToSellingManagerTemplateResponseType::setTemplateID()
     * @param int $templateID
     */
    public function __construct($templateID = null)
    {
        $this
            ->setTemplateID($templateID);
    }
    /**
     * Get TemplateID value
     * @return int|null
     */
    public function getTemplateID()
    {
        return $this->TemplateID;
    }
    /**
     * Set TemplateID value
     * @param int $templateID
     * @return \StructType\SaveItemToSellingManagerTemplateResponseType
     */
    public function setTemplateID($templateID = null)
    {
        // validation for constraint: int
        if (!is_null($templateID) && !is_numeric($templateID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($templateID)), __LINE__);
        }
        $this->TemplateID = $templateID;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SaveItemToSellingManagerTemplateResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
