<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InsuranceDetailsType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Contains the cost of shipping insurance and other insurance-related information.
 * @subpackage Structs
 */
class InsuranceDetailsType extends AbstractStructBase
{
    /**
     * The InsuranceFee
     * Meta informations extracted from the WSDL
     * - documentation: Cost of shipping insurance set by the seller. If the buyer bought more than one of this item, this is the insurance for just a single item. Exception: for <b>GetItemShipping</b>, this is proportional to <b>QuantitySold</b>. Default
     * is 0.00. Value should be greater than 0.00 if <b>InsuranceOption</b> is Optional or Required. For flat shipping only. Optional as input and only allowed if <b>ChangePaymentInstructions</b> is <code>true</code>. <br><br> Valid only on the following
     * sites: AU, FR, and IT <br /> Applicable to Half.com (for <b>GetOrders</b>).
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $InsuranceFee;
    /**
     * The InsuranceOption
     * Meta informations extracted from the WSDL
     * - documentation: Whether the seller offers shipping insurance and, if so, whether the insurance is optional or required. Applies to both flat and calculated shipping. Optional as input and only allowed if <b>ChangePaymentInstructions</b> is true.
     * <br><br> Valid only on the following sites: AU, FR, and IT <br /> Applicable to Half.com (for <b>GetOrders</b>).
     * - minOccurs: 0
     * @var string
     */
    public $InsuranceOption;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for InsuranceDetailsType
     * @uses InsuranceDetailsType::setInsuranceFee()
     * @uses InsuranceDetailsType::setInsuranceOption()
     * @uses InsuranceDetailsType::setAny()
     * @param \StructType\AmountType $insuranceFee
     * @param string $insuranceOption
     * @param \DOMDocument $any
     */
    public function __construct(\StructType\AmountType $insuranceFee = null, $insuranceOption = null, \DOMDocument $any = null)
    {
        $this
            ->setInsuranceFee($insuranceFee)
            ->setInsuranceOption($insuranceOption)
            ->setAny($any);
    }
    /**
     * Get InsuranceFee value
     * @return \StructType\AmountType|null
     */
    public function getInsuranceFee()
    {
        return $this->InsuranceFee;
    }
    /**
     * Set InsuranceFee value
     * @param \StructType\AmountType $insuranceFee
     * @return \StructType\InsuranceDetailsType
     */
    public function setInsuranceFee(\StructType\AmountType $insuranceFee = null)
    {
        $this->InsuranceFee = $insuranceFee;
        return $this;
    }
    /**
     * Get InsuranceOption value
     * @return string|null
     */
    public function getInsuranceOption()
    {
        return $this->InsuranceOption;
    }
    /**
     * Set InsuranceOption value
     * @uses \EnumType\InsuranceOptionCodeType::valueIsValid()
     * @uses \EnumType\InsuranceOptionCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $insuranceOption
     * @return \StructType\InsuranceDetailsType
     */
    public function setInsuranceOption($insuranceOption = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\InsuranceOptionCodeType::valueIsValid($insuranceOption)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $insuranceOption, implode(', ', \EnumType\InsuranceOptionCodeType::getValidValues())), __LINE__);
        }
        $this->InsuranceOption = $insuranceOption;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \StructType\InsuranceDetailsType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \StructType\InsuranceDetailsType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\InsuranceDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
