<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSuggestedCategoriesResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Returns a list of categories with the highest number of listings whose titles or descriptions contain the keywords specified in a GetSuggestedCategoriesRequest.
 * @subpackage Structs
 */
class GetSuggestedCategoriesResponseType extends AbstractResponseType
{
    /**
     * The SuggestedCategoryArray
     * Meta informations extracted from the WSDL
     * - documentation: Contains the categories that contain listings that match the query string in the request. The array can have up to 10 categories. Not returned if no categories match the query in the request.
     * - minOccurs: 0
     * @var \StructType\SuggestedCategoryArrayType
     */
    public $SuggestedCategoryArray;
    /**
     * The CategoryCount
     * Meta informations extracted from the WSDL
     * - documentation: Indicates the number of categories in the array.
     * - minOccurs: 0
     * @var int
     */
    public $CategoryCount;
    /**
     * Constructor method for GetSuggestedCategoriesResponseType
     * @uses GetSuggestedCategoriesResponseType::setSuggestedCategoryArray()
     * @uses GetSuggestedCategoriesResponseType::setCategoryCount()
     * @param \StructType\SuggestedCategoryArrayType $suggestedCategoryArray
     * @param int $categoryCount
     */
    public function __construct(\StructType\SuggestedCategoryArrayType $suggestedCategoryArray = null, $categoryCount = null)
    {
        $this
            ->setSuggestedCategoryArray($suggestedCategoryArray)
            ->setCategoryCount($categoryCount);
    }
    /**
     * Get SuggestedCategoryArray value
     * @return \StructType\SuggestedCategoryArrayType|null
     */
    public function getSuggestedCategoryArray()
    {
        return $this->SuggestedCategoryArray;
    }
    /**
     * Set SuggestedCategoryArray value
     * @param \StructType\SuggestedCategoryArrayType $suggestedCategoryArray
     * @return \StructType\GetSuggestedCategoriesResponseType
     */
    public function setSuggestedCategoryArray(\StructType\SuggestedCategoryArrayType $suggestedCategoryArray = null)
    {
        $this->SuggestedCategoryArray = $suggestedCategoryArray;
        return $this;
    }
    /**
     * Get CategoryCount value
     * @return int|null
     */
    public function getCategoryCount()
    {
        return $this->CategoryCount;
    }
    /**
     * Set CategoryCount value
     * @param int $categoryCount
     * @return \StructType\GetSuggestedCategoriesResponseType
     */
    public function setCategoryCount($categoryCount = null)
    {
        // validation for constraint: int
        if (!is_null($categoryCount) && !is_numeric($categoryCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($categoryCount)), __LINE__);
        }
        $this->CategoryCount = $categoryCount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetSuggestedCategoriesResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
