<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMyeBaySellingResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Returns summary and detail information about items the user is selling, items scheduled to sell, currently listed, sold, and closed but not sold.
 * @subpackage Structs
 */
class GetMyeBaySellingResponseType extends AbstractResponseType
{
    /**
     * The SellingSummary
     * Meta informations extracted from the WSDL
     * - documentation: Contains summary information about the items the user is selling.
     * - minOccurs: 0
     * @var \StructType\SellingSummaryType
     */
    public $SellingSummary;
    /**
     * The ScheduledList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items the user has scheduled for sale, but whose listings have not yet started.
     * - minOccurs: 0
     * @var \StructType\PaginatedItemArrayType
     */
    public $ScheduledList;
    /**
     * The ActiveList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items the user is selling that have active listings.
     * - minOccurs: 0
     * @var \StructType\PaginatedItemArrayType
     */
    public $ActiveList;
    /**
     * The SoldList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items the user has sold.
     * - minOccurs: 0
     * @var \StructType\PaginatedOrderTransactionArrayType
     */
    public $SoldList;
    /**
     * The UnsoldList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items whose listings have ended but that have not sold.
     * - minOccurs: 0
     * @var \StructType\PaginatedItemArrayType
     */
    public $UnsoldList;
    /**
     * The Summary
     * Meta informations extracted from the WSDL
     * - documentation: Contains summary information about the items the user is selling.
     * - minOccurs: 0
     * @var \StructType\MyeBaySellingSummaryType
     */
    public $Summary;
    /**
     * The BidList
     * Meta informations extracted from the WSDL
     * - documentation: This container is no longer applicable to <b>GetMyeBaySelling</b>.
     * - minOccurs: 0
     * @var \StructType\PaginatedItemArrayType
     */
    public $BidList;
    /**
     * The DeletedFromSoldList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items the seller has sold and deleted from My eBay.
     * - minOccurs: 0
     * @var \StructType\PaginatedOrderTransactionArrayType
     */
    public $DeletedFromSoldList;
    /**
     * The DeletedFromUnsoldList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items with listings that were ended or did not sell and have been deleted from My eBay.
     * - minOccurs: 0
     * @var \StructType\PaginatedItemArrayType
     */
    public $DeletedFromUnsoldList;
    /**
     * Constructor method for GetMyeBaySellingResponseType
     * @uses GetMyeBaySellingResponseType::setSellingSummary()
     * @uses GetMyeBaySellingResponseType::setScheduledList()
     * @uses GetMyeBaySellingResponseType::setActiveList()
     * @uses GetMyeBaySellingResponseType::setSoldList()
     * @uses GetMyeBaySellingResponseType::setUnsoldList()
     * @uses GetMyeBaySellingResponseType::setSummary()
     * @uses GetMyeBaySellingResponseType::setBidList()
     * @uses GetMyeBaySellingResponseType::setDeletedFromSoldList()
     * @uses GetMyeBaySellingResponseType::setDeletedFromUnsoldList()
     * @param \StructType\SellingSummaryType $sellingSummary
     * @param \StructType\PaginatedItemArrayType $scheduledList
     * @param \StructType\PaginatedItemArrayType $activeList
     * @param \StructType\PaginatedOrderTransactionArrayType $soldList
     * @param \StructType\PaginatedItemArrayType $unsoldList
     * @param \StructType\MyeBaySellingSummaryType $summary
     * @param \StructType\PaginatedItemArrayType $bidList
     * @param \StructType\PaginatedOrderTransactionArrayType $deletedFromSoldList
     * @param \StructType\PaginatedItemArrayType $deletedFromUnsoldList
     */
    public function __construct(\StructType\SellingSummaryType $sellingSummary = null, \StructType\PaginatedItemArrayType $scheduledList = null, \StructType\PaginatedItemArrayType $activeList = null, \StructType\PaginatedOrderTransactionArrayType $soldList = null, \StructType\PaginatedItemArrayType $unsoldList = null, \StructType\MyeBaySellingSummaryType $summary = null, \StructType\PaginatedItemArrayType $bidList = null, \StructType\PaginatedOrderTransactionArrayType $deletedFromSoldList = null, \StructType\PaginatedItemArrayType $deletedFromUnsoldList = null)
    {
        $this
            ->setSellingSummary($sellingSummary)
            ->setScheduledList($scheduledList)
            ->setActiveList($activeList)
            ->setSoldList($soldList)
            ->setUnsoldList($unsoldList)
            ->setSummary($summary)
            ->setBidList($bidList)
            ->setDeletedFromSoldList($deletedFromSoldList)
            ->setDeletedFromUnsoldList($deletedFromUnsoldList);
    }
    /**
     * Get SellingSummary value
     * @return \StructType\SellingSummaryType|null
     */
    public function getSellingSummary()
    {
        return $this->SellingSummary;
    }
    /**
     * Set SellingSummary value
     * @param \StructType\SellingSummaryType $sellingSummary
     * @return \StructType\GetMyeBaySellingResponseType
     */
    public function setSellingSummary(\StructType\SellingSummaryType $sellingSummary = null)
    {
        $this->SellingSummary = $sellingSummary;
        return $this;
    }
    /**
     * Get ScheduledList value
     * @return \StructType\PaginatedItemArrayType|null
     */
    public function getScheduledList()
    {
        return $this->ScheduledList;
    }
    /**
     * Set ScheduledList value
     * @param \StructType\PaginatedItemArrayType $scheduledList
     * @return \StructType\GetMyeBaySellingResponseType
     */
    public function setScheduledList(\StructType\PaginatedItemArrayType $scheduledList = null)
    {
        $this->ScheduledList = $scheduledList;
        return $this;
    }
    /**
     * Get ActiveList value
     * @return \StructType\PaginatedItemArrayType|null
     */
    public function getActiveList()
    {
        return $this->ActiveList;
    }
    /**
     * Set ActiveList value
     * @param \StructType\PaginatedItemArrayType $activeList
     * @return \StructType\GetMyeBaySellingResponseType
     */
    public function setActiveList(\StructType\PaginatedItemArrayType $activeList = null)
    {
        $this->ActiveList = $activeList;
        return $this;
    }
    /**
     * Get SoldList value
     * @return \StructType\PaginatedOrderTransactionArrayType|null
     */
    public function getSoldList()
    {
        return $this->SoldList;
    }
    /**
     * Set SoldList value
     * @param \StructType\PaginatedOrderTransactionArrayType $soldList
     * @return \StructType\GetMyeBaySellingResponseType
     */
    public function setSoldList(\StructType\PaginatedOrderTransactionArrayType $soldList = null)
    {
        $this->SoldList = $soldList;
        return $this;
    }
    /**
     * Get UnsoldList value
     * @return \StructType\PaginatedItemArrayType|null
     */
    public function getUnsoldList()
    {
        return $this->UnsoldList;
    }
    /**
     * Set UnsoldList value
     * @param \StructType\PaginatedItemArrayType $unsoldList
     * @return \StructType\GetMyeBaySellingResponseType
     */
    public function setUnsoldList(\StructType\PaginatedItemArrayType $unsoldList = null)
    {
        $this->UnsoldList = $unsoldList;
        return $this;
    }
    /**
     * Get Summary value
     * @return \StructType\MyeBaySellingSummaryType|null
     */
    public function getSummary()
    {
        return $this->Summary;
    }
    /**
     * Set Summary value
     * @param \StructType\MyeBaySellingSummaryType $summary
     * @return \StructType\GetMyeBaySellingResponseType
     */
    public function setSummary(\StructType\MyeBaySellingSummaryType $summary = null)
    {
        $this->Summary = $summary;
        return $this;
    }
    /**
     * Get BidList value
     * @return \StructType\PaginatedItemArrayType|null
     */
    public function getBidList()
    {
        return $this->BidList;
    }
    /**
     * Set BidList value
     * @param \StructType\PaginatedItemArrayType $bidList
     * @return \StructType\GetMyeBaySellingResponseType
     */
    public function setBidList(\StructType\PaginatedItemArrayType $bidList = null)
    {
        $this->BidList = $bidList;
        return $this;
    }
    /**
     * Get DeletedFromSoldList value
     * @return \StructType\PaginatedOrderTransactionArrayType|null
     */
    public function getDeletedFromSoldList()
    {
        return $this->DeletedFromSoldList;
    }
    /**
     * Set DeletedFromSoldList value
     * @param \StructType\PaginatedOrderTransactionArrayType $deletedFromSoldList
     * @return \StructType\GetMyeBaySellingResponseType
     */
    public function setDeletedFromSoldList(\StructType\PaginatedOrderTransactionArrayType $deletedFromSoldList = null)
    {
        $this->DeletedFromSoldList = $deletedFromSoldList;
        return $this;
    }
    /**
     * Get DeletedFromUnsoldList value
     * @return \StructType\PaginatedItemArrayType|null
     */
    public function getDeletedFromUnsoldList()
    {
        return $this->DeletedFromUnsoldList;
    }
    /**
     * Set DeletedFromUnsoldList value
     * @param \StructType\PaginatedItemArrayType $deletedFromUnsoldList
     * @return \StructType\GetMyeBaySellingResponseType
     */
    public function setDeletedFromUnsoldList(\StructType\PaginatedItemArrayType $deletedFromUnsoldList = null)
    {
        $this->DeletedFromUnsoldList = $deletedFromUnsoldList;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetMyeBaySellingResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
