<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for SellingManagerTemplateDetailsArrayType ArrayType
 * Meta informations extracted from the WSDL
 * - documentation: A list of Selling Manager templates.
 * @subpackage Arrays
 */
class SellingManagerTemplateDetailsArrayType extends AbstractStructArrayBase
{
    /**
     * The SellingManagerTemplateDetails
     * Meta informations extracted from the WSDL
     * - documentation: Selling Manager template details.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SellingManagerTemplateDetailsType[]
     */
    public $SellingManagerTemplateDetails;
    /**
     * Constructor method for SellingManagerTemplateDetailsArrayType
     * @uses SellingManagerTemplateDetailsArrayType::setSellingManagerTemplateDetails()
     * @param \StructType\SellingManagerTemplateDetailsType[] $sellingManagerTemplateDetails
     */
    public function __construct(array $sellingManagerTemplateDetails = array())
    {
        $this
            ->setSellingManagerTemplateDetails($sellingManagerTemplateDetails);
    }
    /**
     * Get SellingManagerTemplateDetails value
     * @return \StructType\SellingManagerTemplateDetailsType[]|null
     */
    public function getSellingManagerTemplateDetails()
    {
        return $this->SellingManagerTemplateDetails;
    }
    /**
     * Set SellingManagerTemplateDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\SellingManagerTemplateDetailsType[] $sellingManagerTemplateDetails
     * @return \ArrayType\SellingManagerTemplateDetailsArrayType
     */
    public function setSellingManagerTemplateDetails(array $sellingManagerTemplateDetails = array())
    {
        foreach ($sellingManagerTemplateDetails as $sellingManagerTemplateDetailsArrayTypeSellingManagerTemplateDetailsItem) {
            // validation for constraint: itemType
            if (!$sellingManagerTemplateDetailsArrayTypeSellingManagerTemplateDetailsItem instanceof \StructType\SellingManagerTemplateDetailsType) {
                throw new \InvalidArgumentException(sprintf('The SellingManagerTemplateDetails property can only contain items of \StructType\SellingManagerTemplateDetailsType, "%s" given', is_object($sellingManagerTemplateDetailsArrayTypeSellingManagerTemplateDetailsItem) ? get_class($sellingManagerTemplateDetailsArrayTypeSellingManagerTemplateDetailsItem) : gettype($sellingManagerTemplateDetailsArrayTypeSellingManagerTemplateDetailsItem)), __LINE__);
            }
        }
        $this->SellingManagerTemplateDetails = $sellingManagerTemplateDetails;
        return $this;
    }
    /**
     * Add item to SellingManagerTemplateDetails value
     * @throws \InvalidArgumentException
     * @param \StructType\SellingManagerTemplateDetailsType $item
     * @return \ArrayType\SellingManagerTemplateDetailsArrayType
     */
    public function addToSellingManagerTemplateDetails(\StructType\SellingManagerTemplateDetailsType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SellingManagerTemplateDetailsType) {
            throw new \InvalidArgumentException(sprintf('The SellingManagerTemplateDetails property can only contain items of \StructType\SellingManagerTemplateDetailsType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SellingManagerTemplateDetails[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\SellingManagerTemplateDetailsType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\SellingManagerTemplateDetailsType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\SellingManagerTemplateDetailsType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\SellingManagerTemplateDetailsType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\SellingManagerTemplateDetailsType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string SellingManagerTemplateDetails
     */
    public function getAttributeName()
    {
        return 'SellingManagerTemplateDetails';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\SellingManagerTemplateDetailsArrayType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
