<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WarrantyOfferedDetailsType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type used by the <b>ReturnPolicyDetails.WarrantyOffered</b> container, which is returned in <b>GeteBayDetails</b> response to indicate if a warranty may be offered by the seller to the buyer in a listing.
 * @subpackage Structs
 */
class WarrantyOfferedDetailsType extends AbstractStructBase
{
    /**
     * The WarrantyOfferedOption
     * Meta informations extracted from the WSDL
     * - documentation: The enumeration value in this field indicates whether or not a warranty may be offered by the seller to the buyer in a listing. This value can be passed in through the <b>ReturnPolicy.WarrantyOfferedOption</b> field in an
     * add/revise/relist API call to offer a warranty to the buyer. If the seller is offering a warranty to the buyer, the type of warranty should be passed in through the <b>ReturnPolicy.WarrantyTypeOption</b> field in an add/revise/relist API call.
     * - minOccurs: 0
     * @var string
     */
    public $WarrantyOfferedOption;
    /**
     * The Description
     * Meta informations extracted from the WSDL
     * - documentation: This string field is a textual description of the warranty offered enumeration value.
     * - minOccurs: 0
     * @var string
     */
    public $Description;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for WarrantyOfferedDetailsType
     * @uses WarrantyOfferedDetailsType::setWarrantyOfferedOption()
     * @uses WarrantyOfferedDetailsType::setDescription()
     * @uses WarrantyOfferedDetailsType::setAny()
     * @param string $warrantyOfferedOption
     * @param string $description
     * @param \DOMDocument $any
     */
    public function __construct($warrantyOfferedOption = null, $description = null, \DOMDocument $any = null)
    {
        $this
            ->setWarrantyOfferedOption($warrantyOfferedOption)
            ->setDescription($description)
            ->setAny($any);
    }
    /**
     * Get WarrantyOfferedOption value
     * @return string|null
     */
    public function getWarrantyOfferedOption()
    {
        return $this->WarrantyOfferedOption;
    }
    /**
     * Set WarrantyOfferedOption value
     * @param string $warrantyOfferedOption
     * @return \StructType\WarrantyOfferedDetailsType
     */
    public function setWarrantyOfferedOption($warrantyOfferedOption = null)
    {
        // validation for constraint: string
        if (!is_null($warrantyOfferedOption) && !is_string($warrantyOfferedOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($warrantyOfferedOption)), __LINE__);
        }
        $this->WarrantyOfferedOption = $warrantyOfferedOption;
        return $this;
    }
    /**
     * Get Description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->Description;
    }
    /**
     * Set Description value
     * @param string $description
     * @return \StructType\WarrantyOfferedDetailsType
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->Description = $description;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \StructType\WarrantyOfferedDetailsType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \StructType\WarrantyOfferedDetailsType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WarrantyOfferedDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
