<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SiteBuyerRequirementDetailsType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Type defining the <b>BuyerRequirementDetails</b> container, which is returned in <b>GeteBayDetails</b>, and provides the seller with the buyer requirement features (and applicable values) that are supported by the listing site.
 * <br/><br/> <span class="tablenote"><b>Note: </b> This container is only returned if <b>BuyerRequirementDetails</b> is included as a <b>DetailName</b> filter in the call request, or if no <b>DetailName</b> filters are used in the request. </span>
 * @subpackage Structs
 */
class SiteBuyerRequirementDetailsType extends AbstractStructBase
{
    /**
     * The LinkedPayPalAccount
     * Meta informations extracted from the WSDL
     * - documentation: Specifies that the site's buyer requirements support PayPal.
     * - minOccurs: 0
     * @var bool
     */
    public $LinkedPayPalAccount;
    /**
     * The MaximumBuyerPolicyViolations
     * Meta informations extracted from the WSDL
     * - documentation: Blocks bidders who have reached the maximum allowed buyer policy violation stricks (in a specific time period) from bidding on this item.
     * - minOccurs: 0
     * @var \StructType\MaximumBuyerPolicyViolationsDetailsType
     */
    public $MaximumBuyerPolicyViolations;
    /**
     * The MaximumItemRequirements
     * Meta informations extracted from the WSDL
     * - documentation: Limits unpaying or low feedback bidders, by setting the MaximumItemCount and MinimumFeedbackScore to define when a bidder is blocked from bidding.
     * - minOccurs: 0
     * @var \StructType\MaximumItemRequirementsDetailsType
     */
    public $MaximumItemRequirements;
    /**
     * The MaximumUnpaidItemStrikesInfo
     * Meta informations extracted from the WSDL
     * - documentation: Specifies a maximum number of unpaid items strikes that will result in blocking a bidder from bidding on the item (within a specific time period).
     * - minOccurs: 0
     * @var \StructType\MaximumUnpaidItemStrikesInfoDetailsType
     */
    public $MaximumUnpaidItemStrikesInfo;
    /**
     * The MinimumFeedbackScore
     * Meta informations extracted from the WSDL
     * - documentation: This container consists of the values that can be used in the <b>BuyerRequirementDetails.MinimumFeedbackScore</b> field when listing an item through an Add/Revise/Relist API call. The Feedback Score for a potential buyer must be
     * greater than or equal to the specified value, or that buyer is blocked from buying the item. <br/><br/> For this container to appear in the response, <b>BuyerRequirementDetails</b> must be one of the values passed into the <b>DetailLevel</b> field in
     * the request (or, no <b>DetailLevel</b> filters should be used).
     * - minOccurs: 0
     * @var \StructType\MinimumFeedbackScoreDetailsType
     */
    public $MinimumFeedbackScore;
    /**
     * The ShipToRegistrationCountry
     * Meta informations extracted from the WSDL
     * - documentation: Specifies that the site's buyer requirements support ShipToRegistrationCountry.
     * - minOccurs: 0
     * @var bool
     */
    public $ShipToRegistrationCountry;
    /**
     * The VerifiedUserRequirements
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the valid values for limiting unverified bidders.
     * - minOccurs: 0
     * @var \StructType\VerifiedUserRequirementsDetailsType
     */
    public $VerifiedUserRequirements;
    /**
     * The DetailVersion
     * Meta informations extracted from the WSDL
     * - documentation: Returns the latest version number for this field. The version can be used to determine if and when to refresh cached client data.
     * - minOccurs: 0
     * @var string
     */
    public $DetailVersion;
    /**
     * The UpdateTime
     * Meta informations extracted from the WSDL
     * - documentation: Gives the time in GMT when the feature flags for the details were last updated. This timestamp can be used to determine if and when to refresh cached client data.
     * - minOccurs: 0
     * @var string
     */
    public $UpdateTime;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for SiteBuyerRequirementDetailsType
     * @uses SiteBuyerRequirementDetailsType::setLinkedPayPalAccount()
     * @uses SiteBuyerRequirementDetailsType::setMaximumBuyerPolicyViolations()
     * @uses SiteBuyerRequirementDetailsType::setMaximumItemRequirements()
     * @uses SiteBuyerRequirementDetailsType::setMaximumUnpaidItemStrikesInfo()
     * @uses SiteBuyerRequirementDetailsType::setMinimumFeedbackScore()
     * @uses SiteBuyerRequirementDetailsType::setShipToRegistrationCountry()
     * @uses SiteBuyerRequirementDetailsType::setVerifiedUserRequirements()
     * @uses SiteBuyerRequirementDetailsType::setDetailVersion()
     * @uses SiteBuyerRequirementDetailsType::setUpdateTime()
     * @uses SiteBuyerRequirementDetailsType::setAny()
     * @param bool $linkedPayPalAccount
     * @param \StructType\MaximumBuyerPolicyViolationsDetailsType $maximumBuyerPolicyViolations
     * @param \StructType\MaximumItemRequirementsDetailsType $maximumItemRequirements
     * @param \StructType\MaximumUnpaidItemStrikesInfoDetailsType $maximumUnpaidItemStrikesInfo
     * @param \StructType\MinimumFeedbackScoreDetailsType $minimumFeedbackScore
     * @param bool $shipToRegistrationCountry
     * @param \StructType\VerifiedUserRequirementsDetailsType $verifiedUserRequirements
     * @param string $detailVersion
     * @param string $updateTime
     * @param \DOMDocument $any
     */
    public function __construct($linkedPayPalAccount = null, \StructType\MaximumBuyerPolicyViolationsDetailsType $maximumBuyerPolicyViolations = null, \StructType\MaximumItemRequirementsDetailsType $maximumItemRequirements = null, \StructType\MaximumUnpaidItemStrikesInfoDetailsType $maximumUnpaidItemStrikesInfo = null, \StructType\MinimumFeedbackScoreDetailsType $minimumFeedbackScore = null, $shipToRegistrationCountry = null, \StructType\VerifiedUserRequirementsDetailsType $verifiedUserRequirements = null, $detailVersion = null, $updateTime = null, \DOMDocument $any = null)
    {
        $this
            ->setLinkedPayPalAccount($linkedPayPalAccount)
            ->setMaximumBuyerPolicyViolations($maximumBuyerPolicyViolations)
            ->setMaximumItemRequirements($maximumItemRequirements)
            ->setMaximumUnpaidItemStrikesInfo($maximumUnpaidItemStrikesInfo)
            ->setMinimumFeedbackScore($minimumFeedbackScore)
            ->setShipToRegistrationCountry($shipToRegistrationCountry)
            ->setVerifiedUserRequirements($verifiedUserRequirements)
            ->setDetailVersion($detailVersion)
            ->setUpdateTime($updateTime)
            ->setAny($any);
    }
    /**
     * Get LinkedPayPalAccount value
     * @return bool|null
     */
    public function getLinkedPayPalAccount()
    {
        return $this->LinkedPayPalAccount;
    }
    /**
     * Set LinkedPayPalAccount value
     * @param bool $linkedPayPalAccount
     * @return \StructType\SiteBuyerRequirementDetailsType
     */
    public function setLinkedPayPalAccount($linkedPayPalAccount = null)
    {
        $this->LinkedPayPalAccount = $linkedPayPalAccount;
        return $this;
    }
    /**
     * Get MaximumBuyerPolicyViolations value
     * @return \StructType\MaximumBuyerPolicyViolationsDetailsType|null
     */
    public function getMaximumBuyerPolicyViolations()
    {
        return $this->MaximumBuyerPolicyViolations;
    }
    /**
     * Set MaximumBuyerPolicyViolations value
     * @param \StructType\MaximumBuyerPolicyViolationsDetailsType $maximumBuyerPolicyViolations
     * @return \StructType\SiteBuyerRequirementDetailsType
     */
    public function setMaximumBuyerPolicyViolations(\StructType\MaximumBuyerPolicyViolationsDetailsType $maximumBuyerPolicyViolations = null)
    {
        $this->MaximumBuyerPolicyViolations = $maximumBuyerPolicyViolations;
        return $this;
    }
    /**
     * Get MaximumItemRequirements value
     * @return \StructType\MaximumItemRequirementsDetailsType|null
     */
    public function getMaximumItemRequirements()
    {
        return $this->MaximumItemRequirements;
    }
    /**
     * Set MaximumItemRequirements value
     * @param \StructType\MaximumItemRequirementsDetailsType $maximumItemRequirements
     * @return \StructType\SiteBuyerRequirementDetailsType
     */
    public function setMaximumItemRequirements(\StructType\MaximumItemRequirementsDetailsType $maximumItemRequirements = null)
    {
        $this->MaximumItemRequirements = $maximumItemRequirements;
        return $this;
    }
    /**
     * Get MaximumUnpaidItemStrikesInfo value
     * @return \StructType\MaximumUnpaidItemStrikesInfoDetailsType|null
     */
    public function getMaximumUnpaidItemStrikesInfo()
    {
        return $this->MaximumUnpaidItemStrikesInfo;
    }
    /**
     * Set MaximumUnpaidItemStrikesInfo value
     * @param \StructType\MaximumUnpaidItemStrikesInfoDetailsType $maximumUnpaidItemStrikesInfo
     * @return \StructType\SiteBuyerRequirementDetailsType
     */
    public function setMaximumUnpaidItemStrikesInfo(\StructType\MaximumUnpaidItemStrikesInfoDetailsType $maximumUnpaidItemStrikesInfo = null)
    {
        $this->MaximumUnpaidItemStrikesInfo = $maximumUnpaidItemStrikesInfo;
        return $this;
    }
    /**
     * Get MinimumFeedbackScore value
     * @return \StructType\MinimumFeedbackScoreDetailsType|null
     */
    public function getMinimumFeedbackScore()
    {
        return $this->MinimumFeedbackScore;
    }
    /**
     * Set MinimumFeedbackScore value
     * @param \StructType\MinimumFeedbackScoreDetailsType $minimumFeedbackScore
     * @return \StructType\SiteBuyerRequirementDetailsType
     */
    public function setMinimumFeedbackScore(\StructType\MinimumFeedbackScoreDetailsType $minimumFeedbackScore = null)
    {
        $this->MinimumFeedbackScore = $minimumFeedbackScore;
        return $this;
    }
    /**
     * Get ShipToRegistrationCountry value
     * @return bool|null
     */
    public function getShipToRegistrationCountry()
    {
        return $this->ShipToRegistrationCountry;
    }
    /**
     * Set ShipToRegistrationCountry value
     * @param bool $shipToRegistrationCountry
     * @return \StructType\SiteBuyerRequirementDetailsType
     */
    public function setShipToRegistrationCountry($shipToRegistrationCountry = null)
    {
        $this->ShipToRegistrationCountry = $shipToRegistrationCountry;
        return $this;
    }
    /**
     * Get VerifiedUserRequirements value
     * @return \StructType\VerifiedUserRequirementsDetailsType|null
     */
    public function getVerifiedUserRequirements()
    {
        return $this->VerifiedUserRequirements;
    }
    /**
     * Set VerifiedUserRequirements value
     * @param \StructType\VerifiedUserRequirementsDetailsType $verifiedUserRequirements
     * @return \StructType\SiteBuyerRequirementDetailsType
     */
    public function setVerifiedUserRequirements(\StructType\VerifiedUserRequirementsDetailsType $verifiedUserRequirements = null)
    {
        $this->VerifiedUserRequirements = $verifiedUserRequirements;
        return $this;
    }
    /**
     * Get DetailVersion value
     * @return string|null
     */
    public function getDetailVersion()
    {
        return $this->DetailVersion;
    }
    /**
     * Set DetailVersion value
     * @param string $detailVersion
     * @return \StructType\SiteBuyerRequirementDetailsType
     */
    public function setDetailVersion($detailVersion = null)
    {
        // validation for constraint: string
        if (!is_null($detailVersion) && !is_string($detailVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($detailVersion)), __LINE__);
        }
        $this->DetailVersion = $detailVersion;
        return $this;
    }
    /**
     * Get UpdateTime value
     * @return string|null
     */
    public function getUpdateTime()
    {
        return $this->UpdateTime;
    }
    /**
     * Set UpdateTime value
     * @param string $updateTime
     * @return \StructType\SiteBuyerRequirementDetailsType
     */
    public function setUpdateTime($updateTime = null)
    {
        // validation for constraint: string
        if (!is_null($updateTime) && !is_string($updateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($updateTime)), __LINE__);
        }
        $this->UpdateTime = $updateTime;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \StructType\SiteBuyerRequirementDetailsType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \StructType\SiteBuyerRequirementDetailsType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SiteBuyerRequirementDetailsType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
