<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetTaxTableRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Sets the tax table for a seller on a given site.
 * @subpackage Structs
 */
class SetTaxTableRequestType extends AbstractRequestType
{
    /**
     * The TaxTable
     * Meta informations extracted from the WSDL
     * - documentation: A container of tax jurisdiction information unique to a user/site combination.
     * - minOccurs: 0
     * @var \StructType\TaxTableType
     */
    public $TaxTable;
    /**
     * Constructor method for SetTaxTableRequestType
     * @uses SetTaxTableRequestType::setTaxTable()
     * @param \StructType\TaxTableType $taxTable
     */
    public function __construct(\StructType\TaxTableType $taxTable = null)
    {
        $this
            ->setTaxTable($taxTable);
    }
    /**
     * Get TaxTable value
     * @return \StructType\TaxTableType|null
     */
    public function getTaxTable()
    {
        return $this->TaxTable;
    }
    /**
     * Set TaxTable value
     * @param \StructType\TaxTableType $taxTable
     * @return \StructType\SetTaxTableRequestType
     */
    public function setTaxTable(\StructType\TaxTableType $taxTable = null)
    {
        $this->TaxTable = $taxTable;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SetTaxTableRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
