<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReviseInventoryStatusRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Enables a seller to change the price and quantity of a currently- active, fixed-price listing. Using ReviseInventoryStatus to modify data qualifies as revising the listing. <br> <br> Inputs are the item IDs or SKUs of the listings
 * being revised, and the price and quantity that are being changed for each revision. Only applicable to fixed-price listings.<br> <br> Changing the price or quantity of a currently- active, fixed-price listing does not reset the Best Match performance
 * score. For Best Match information related to multi-variation listings, see the Best Match information at the following topic: <a href="http://pages.ebay.com/sell/variation/">Multi-quantity Fixed Price listings with variations</a>.<br> <br> As with
 * all listing calls, the site you specify in the request URL (for SOAP) or the X-EBAY-API-SITEID HTTP header (for XML) should match the original listing's <b>Item.Site</b> value. In particular, this is a best practice when you submit new and revised
 * listings.<br> <br> <b>For Large Merchant Services users:</b> When you use ReviseInventoryStatus within a Merchant Data file, it must be enclosed within two BulkDataExchangeRequest tags. After release 637, a namespace is returned in the
 * BulkDataExchangeResponseType (top level) of the response. The BulkDataExchange tags are not shown in the call input/output descriptions.
 * @subpackage Structs
 */
class ReviseInventoryStatusRequestType extends AbstractRequestType
{
    /**
     * The InventoryStatus
     * Meta informations extracted from the WSDL
     * - documentation: Contains the updated quantity and/or price of a listing being revised. You should not modify the same listing twice (by using a duplicate ItemID or SKU) in the same request; otherwise, you may get an error or unexpected results. (For
     * example, you should not use one InventoryStatus node to update the quantity and another InventoryStatus node to update the price of the same item.) You can pass up to 4 InventoryStatus nodes in a single request.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InventoryStatusType[]
     */
    public $InventoryStatus;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for ReviseInventoryStatusRequestType
     * @uses ReviseInventoryStatusRequestType::setInventoryStatus()
     * @uses ReviseInventoryStatusRequestType::setAny()
     * @param \StructType\InventoryStatusType[] $inventoryStatus
     * @param \DOMDocument $any
     */
    public function __construct(array $inventoryStatus = array(), \DOMDocument $any = null)
    {
        $this
            ->setInventoryStatus($inventoryStatus)
            ->setAny($any);
    }
    /**
     * Get InventoryStatus value
     * @return \StructType\InventoryStatusType[]|null
     */
    public function getInventoryStatus()
    {
        return $this->InventoryStatus;
    }
    /**
     * Set InventoryStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\InventoryStatusType[] $inventoryStatus
     * @return \StructType\ReviseInventoryStatusRequestType
     */
    public function setInventoryStatus(array $inventoryStatus = array())
    {
        foreach ($inventoryStatus as $reviseInventoryStatusRequestTypeInventoryStatusItem) {
            // validation for constraint: itemType
            if (!$reviseInventoryStatusRequestTypeInventoryStatusItem instanceof \StructType\InventoryStatusType) {
                throw new \InvalidArgumentException(sprintf('The InventoryStatus property can only contain items of \StructType\InventoryStatusType, "%s" given', is_object($reviseInventoryStatusRequestTypeInventoryStatusItem) ? get_class($reviseInventoryStatusRequestTypeInventoryStatusItem) : gettype($reviseInventoryStatusRequestTypeInventoryStatusItem)), __LINE__);
            }
        }
        $this->InventoryStatus = $inventoryStatus;
        return $this;
    }
    /**
     * Add item to InventoryStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\InventoryStatusType $item
     * @return \StructType\ReviseInventoryStatusRequestType
     */
    public function addToInventoryStatus(\StructType\InventoryStatusType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InventoryStatusType) {
            throw new \InvalidArgumentException(sprintf('The InventoryStatus property can only contain items of \StructType\InventoryStatusType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->InventoryStatus[] = $item;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \StructType\ReviseInventoryStatusRequestType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \StructType\ReviseInventoryStatusRequestType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReviseInventoryStatusRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
