<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSellingManagerInventoryRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Retrieves a paginated list containing details of a user's Selling Manager inventory. This call is subject to change without notice; the deprecation process is inapplicable to this call.
 * @subpackage Structs
 */
class GetSellingManagerInventoryRequestType extends AbstractRequestType
{
    /**
     * The Sort
     * Meta informations extracted from the WSDL
     * - documentation: Sets the sorting method for the results.
     * - minOccurs: 0
     * @var string
     */
    public $Sort;
    /**
     * The FolderID
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the inventory folder containing the requested inventory information.
     * - minOccurs: 0
     * @var int
     */
    public $FolderID;
    /**
     * The Pagination
     * Meta informations extracted from the WSDL
     * - documentation: Details about how many Products to return per page and which page to view.
     * - minOccurs: 0
     * @var \StructType\PaginationType
     */
    public $Pagination;
    /**
     * The SortOrder
     * Meta informations extracted from the WSDL
     * - documentation: Order to be used for sorting retrieved product lists.
     * - minOccurs: 0
     * @var string
     */
    public $SortOrder;
    /**
     * The Search
     * Meta informations extracted from the WSDL
     * - documentation: Specifies types and values to search for in the seller's listings.
     * - minOccurs: 0
     * @var \StructType\SellingManagerSearchType
     */
    public $Search;
    /**
     * The StoreCategoryID
     * Meta informations extracted from the WSDL
     * - documentation: Specifies a store category whose products will be returned.
     * - minOccurs: 0
     * @var int
     */
    public $StoreCategoryID;
    /**
     * The Filter
     * Meta informations extracted from the WSDL
     * - documentation: Container for the list of filters that can be applied to the inventory information requested.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $Filter;
    /**
     * Constructor method for GetSellingManagerInventoryRequestType
     * @uses GetSellingManagerInventoryRequestType::setSort()
     * @uses GetSellingManagerInventoryRequestType::setFolderID()
     * @uses GetSellingManagerInventoryRequestType::setPagination()
     * @uses GetSellingManagerInventoryRequestType::setSortOrder()
     * @uses GetSellingManagerInventoryRequestType::setSearch()
     * @uses GetSellingManagerInventoryRequestType::setStoreCategoryID()
     * @uses GetSellingManagerInventoryRequestType::setFilter()
     * @param string $sort
     * @param int $folderID
     * @param \StructType\PaginationType $pagination
     * @param string $sortOrder
     * @param \StructType\SellingManagerSearchType $search
     * @param int $storeCategoryID
     * @param string[] $filter
     */
    public function __construct($sort = null, $folderID = null, \StructType\PaginationType $pagination = null, $sortOrder = null, \StructType\SellingManagerSearchType $search = null, $storeCategoryID = null, array $filter = array())
    {
        $this
            ->setSort($sort)
            ->setFolderID($folderID)
            ->setPagination($pagination)
            ->setSortOrder($sortOrder)
            ->setSearch($search)
            ->setStoreCategoryID($storeCategoryID)
            ->setFilter($filter);
    }
    /**
     * Get Sort value
     * @return string|null
     */
    public function getSort()
    {
        return $this->Sort;
    }
    /**
     * Set Sort value
     * @uses \EnumType\SellingManagerProductSortCodeType::valueIsValid()
     * @uses \EnumType\SellingManagerProductSortCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sort
     * @return \StructType\GetSellingManagerInventoryRequestType
     */
    public function setSort($sort = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SellingManagerProductSortCodeType::valueIsValid($sort)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sort, implode(', ', \EnumType\SellingManagerProductSortCodeType::getValidValues())), __LINE__);
        }
        $this->Sort = $sort;
        return $this;
    }
    /**
     * Get FolderID value
     * @return int|null
     */
    public function getFolderID()
    {
        return $this->FolderID;
    }
    /**
     * Set FolderID value
     * @param int $folderID
     * @return \StructType\GetSellingManagerInventoryRequestType
     */
    public function setFolderID($folderID = null)
    {
        // validation for constraint: int
        if (!is_null($folderID) && !is_numeric($folderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($folderID)), __LINE__);
        }
        $this->FolderID = $folderID;
        return $this;
    }
    /**
     * Get Pagination value
     * @return \StructType\PaginationType|null
     */
    public function getPagination()
    {
        return $this->Pagination;
    }
    /**
     * Set Pagination value
     * @param \StructType\PaginationType $pagination
     * @return \StructType\GetSellingManagerInventoryRequestType
     */
    public function setPagination(\StructType\PaginationType $pagination = null)
    {
        $this->Pagination = $pagination;
        return $this;
    }
    /**
     * Get SortOrder value
     * @return string|null
     */
    public function getSortOrder()
    {
        return $this->SortOrder;
    }
    /**
     * Set SortOrder value
     * @uses \EnumType\SortOrderCodeType::valueIsValid()
     * @uses \EnumType\SortOrderCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sortOrder
     * @return \StructType\GetSellingManagerInventoryRequestType
     */
    public function setSortOrder($sortOrder = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SortOrderCodeType::valueIsValid($sortOrder)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sortOrder, implode(', ', \EnumType\SortOrderCodeType::getValidValues())), __LINE__);
        }
        $this->SortOrder = $sortOrder;
        return $this;
    }
    /**
     * Get Search value
     * @return \StructType\SellingManagerSearchType|null
     */
    public function getSearch()
    {
        return $this->Search;
    }
    /**
     * Set Search value
     * @param \StructType\SellingManagerSearchType $search
     * @return \StructType\GetSellingManagerInventoryRequestType
     */
    public function setSearch(\StructType\SellingManagerSearchType $search = null)
    {
        $this->Search = $search;
        return $this;
    }
    /**
     * Get StoreCategoryID value
     * @return int|null
     */
    public function getStoreCategoryID()
    {
        return $this->StoreCategoryID;
    }
    /**
     * Set StoreCategoryID value
     * @param int $storeCategoryID
     * @return \StructType\GetSellingManagerInventoryRequestType
     */
    public function setStoreCategoryID($storeCategoryID = null)
    {
        // validation for constraint: int
        if (!is_null($storeCategoryID) && !is_numeric($storeCategoryID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($storeCategoryID)), __LINE__);
        }
        $this->StoreCategoryID = $storeCategoryID;
        return $this;
    }
    /**
     * Get Filter value
     * @return string[]|null
     */
    public function getFilter()
    {
        return $this->Filter;
    }
    /**
     * Set Filter value
     * @uses \EnumType\SellingManagerInventoryPropertyTypeCodeType::valueIsValid()
     * @uses \EnumType\SellingManagerInventoryPropertyTypeCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $filter
     * @return \StructType\GetSellingManagerInventoryRequestType
     */
    public function setFilter(array $filter = array())
    {
        $invalidValues = array();
        foreach ($filter as $getSellingManagerInventoryRequestTypeFilterItem) {
            if (!\EnumType\SellingManagerInventoryPropertyTypeCodeType::valueIsValid($getSellingManagerInventoryRequestTypeFilterItem)) {
                $invalidValues[] = var_export($getSellingManagerInventoryRequestTypeFilterItem);
            }
        }
        if (!empty($invalidValues)) {
            throw new \InvalidArgumentException(sprintf('Value(s) "%s" is/are invalid, please use one of: %s', implode(', ', $invalidValues), implode(', ', \EnumType\SellingManagerInventoryPropertyTypeCodeType::getValidValues())), __LINE__);
        }
        $this->Filter = $filter;
        return $this;
    }
    /**
     * Add item to Filter value
     * @uses \EnumType\SellingManagerInventoryPropertyTypeCodeType::valueIsValid()
     * @uses \EnumType\SellingManagerInventoryPropertyTypeCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\GetSellingManagerInventoryRequestType
     */
    public function addToFilter($item)
    {
        // validation for constraint: enumeration
        if (!\EnumType\SellingManagerInventoryPropertyTypeCodeType::valueIsValid($item)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $item, implode(', ', \EnumType\SellingManagerInventoryPropertyTypeCodeType::getValidValues())), __LINE__);
        }
        $this->Filter[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetSellingManagerInventoryRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
