<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSellerPaymentsRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: <b>Half.com only.</b>&nbsp;Retrieves a summary of pending or paid payments that Half.com created for the seller identified by the authentication token in the request. This call retrieves only payments that occurred within a
 * particular pay period. <br/><br/> Each payment is for one order line item in one order. An order can contain order line items for multiple items from multiple sellers, but this call only retrieves payments that are relevant to one seller. The
 * financial value of a payment is typically based on an amount that a buyer paid to Half.com for an order line item, with adjustments for shipping costs and Half.com's commission. <br/><br/> For most sellers, each month contains two pay periods: One
 * from the 1st to the 15th of the month, and one from the 16th to the last day of the month. Sellers can refer to their account information on the Half.com site to determine their pay periods. (You cannot retrieve a seller's pay periods by using eBay
 * API.) <br/><br/> When a buyer makes a purchase and an order is created, Half.com creates a payment for the seller and marks it as <b>Pending</b> in the seller's Half.com account. Within a certain number of days after the pay period ends, Half.com
 * settles payments for that period and marks each completed payment as Paid. <br/><br/> See the Half.com Web site online help for more information about how payments are managed.
 * @subpackage Structs
 */
class GetSellerPaymentsRequestType extends AbstractRequestType
{
    /**
     * The PaymentStatus
     * Meta informations extracted from the WSDL
     * - documentation: A filter to retrieve only items with the specified payment status (Paid or Pending). <b></b> <ul> <li><b>Pending payments</b> are payments that Half.com has created but that have not yet been sent to the seller's financial
     * institution. Pending payments are typically available once a buyer pays for an order. As Half.com processes payments by using periodic batch jobs, the <b>GetSellerPayments</b> response might not include an order line item's payment for up to 20
     * minutes after the buyer has paid. You can retrieve pending payments for the current pay period. Pending payments that have not been settled yet can also be retrieved for previous pay periods. </li> <li><b>Paid payments</b> are payments that Half.com
     * processed during previous pay periods. Paid payments might not appear in the seller's financial institution account balance until a certain number of days after the current pay period ends (see the Half.com online help for details). You can only
     * retrieve paid payments for one previous pay period at a time.</li> </ul>
     * - minOccurs: 0
     * @var string
     */
    public $PaymentStatus;
    /**
     * The PaymentTimeFrom
     * Meta informations extracted from the WSDL
     * - documentation: Time range filter that retrieves Half.com payments that were created within a single pay period. Sellers can refer to the Half.com site to determine their pay periods. <b>PaymentTimeFrom</b> is the earliest (oldest) time and
     * <b>PaymentTimeTo</b> is the latest (most recent) time in the range. Half.com pay periods start and end at midnight Pacific time, but the time values are stored in the database in GMT (not Pacific time). See "Time Values" in the eBay Features Guide
     * for information about converting between GMT and Pacific time. <br> <br> If you specify a <b>PaymentStatus</b> of <b>Pending</b>, add a buffer of one hour (or one day) to both ends of the time range to retrieve more data than you need, and then
     * filter the results on the client side as needed. If any pending payments match the request, the response may include all payments since the beginning of the period. <br> <br> If you specify a <b>PaymentStatus</b> of <b>Paid</b>, the time range must
     * contain one full pay period. That is, <b>PaymentTimeFrom</b> must be earlier or equal the start time of the pay period, and <b>PaymentTimeTo</b> must be later than or equal to the end time of the pay period. Otherwise, no paid payments are returned.
     * For example, if the pay period starts on 2005-09-16 and ends on 2005-09-30, you could specify an earlier <b>PaymentTimeFrom</b> value of 2005-09-16T00:00:00.000Z and a later <b>PaymentTimeTo</b> value of 2005-10-01T12:00:00.000Z. <br> <br> If you
     * specify a time range that covers two pay periods, only the payments from the most recent pay period are returned. The earliest time you can specify is 18 months ago.
     * - minOccurs: 0
     * @var string
     */
    public $PaymentTimeFrom;
    /**
     * The PaymentTimeTo
     * Meta informations extracted from the WSDL
     * - documentation: Time range filter that retrieves Half.com payments for a single pay period. See the description of <b>PaymentTimeTo</b> for details about using this time range filter. For paid payments, this value should be equal to or later than
     * the end of the last day of the pay period, where the time is converted to GMT. For example, if the period ends on 2005-09-30, you could specify 2005-10-01T09:00:00.000Z, which is later than the end of the last day.
     * - minOccurs: 0
     * @var string
     */
    public $PaymentTimeTo;
    /**
     * The Pagination
     * Meta informations extracted from the WSDL
     * - documentation: If many payments are available, you may need to call <b>GetSellerPayments</b> multiple times to retrieve all the data. Each result set is returned as a page of entries. Use this <b>Pagination</b> information to indicate the maximum
     * number of entries to retrieve per page (i.e., per call), the page number to retrieve, and other data.
     * - minOccurs: 0
     * @var \StructType\PaginationType
     */
    public $Pagination;
    /**
     * Constructor method for GetSellerPaymentsRequestType
     * @uses GetSellerPaymentsRequestType::setPaymentStatus()
     * @uses GetSellerPaymentsRequestType::setPaymentTimeFrom()
     * @uses GetSellerPaymentsRequestType::setPaymentTimeTo()
     * @uses GetSellerPaymentsRequestType::setPagination()
     * @param string $paymentStatus
     * @param string $paymentTimeFrom
     * @param string $paymentTimeTo
     * @param \StructType\PaginationType $pagination
     */
    public function __construct($paymentStatus = null, $paymentTimeFrom = null, $paymentTimeTo = null, \StructType\PaginationType $pagination = null)
    {
        $this
            ->setPaymentStatus($paymentStatus)
            ->setPaymentTimeFrom($paymentTimeFrom)
            ->setPaymentTimeTo($paymentTimeTo)
            ->setPagination($pagination);
    }
    /**
     * Get PaymentStatus value
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return $this->PaymentStatus;
    }
    /**
     * Set PaymentStatus value
     * @uses \EnumType\RCSPaymentStatusCodeType::valueIsValid()
     * @uses \EnumType\RCSPaymentStatusCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentStatus
     * @return \StructType\GetSellerPaymentsRequestType
     */
    public function setPaymentStatus($paymentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RCSPaymentStatusCodeType::valueIsValid($paymentStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $paymentStatus, implode(', ', \EnumType\RCSPaymentStatusCodeType::getValidValues())), __LINE__);
        }
        $this->PaymentStatus = $paymentStatus;
        return $this;
    }
    /**
     * Get PaymentTimeFrom value
     * @return string|null
     */
    public function getPaymentTimeFrom()
    {
        return $this->PaymentTimeFrom;
    }
    /**
     * Set PaymentTimeFrom value
     * @param string $paymentTimeFrom
     * @return \StructType\GetSellerPaymentsRequestType
     */
    public function setPaymentTimeFrom($paymentTimeFrom = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTimeFrom) && !is_string($paymentTimeFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentTimeFrom)), __LINE__);
        }
        $this->PaymentTimeFrom = $paymentTimeFrom;
        return $this;
    }
    /**
     * Get PaymentTimeTo value
     * @return string|null
     */
    public function getPaymentTimeTo()
    {
        return $this->PaymentTimeTo;
    }
    /**
     * Set PaymentTimeTo value
     * @param string $paymentTimeTo
     * @return \StructType\GetSellerPaymentsRequestType
     */
    public function setPaymentTimeTo($paymentTimeTo = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTimeTo) && !is_string($paymentTimeTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($paymentTimeTo)), __LINE__);
        }
        $this->PaymentTimeTo = $paymentTimeTo;
        return $this;
    }
    /**
     * Get Pagination value
     * @return \StructType\PaginationType|null
     */
    public function getPagination()
    {
        return $this->Pagination;
    }
    /**
     * Set Pagination value
     * @param \StructType\PaginationType $pagination
     * @return \StructType\GetSellerPaymentsRequestType
     */
    public function setPagination(\StructType\PaginationType $pagination = null)
    {
        $this->Pagination = $pagination;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetSellerPaymentsRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
