<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddOrderResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: This type defines the response of an <b>AddOrder</b> call. This response includes a unique identifier for the order (automatically generated by eBay) and a timestamp indicating when the new 'Combined Invoice' order was created.
 * @subpackage Structs
 */
class AddOrderResponseType extends AbstractResponseType
{
    /**
     * The OrderID
     * Meta informations extracted from the WSDL
     * - documentation: The unique identifier for the Combined Invoice order. This value is created by eBay upon a successful <b>AddOrder</b> call. This value can be used as an input filter in <a href="GetOrders.html">GetOrders</a> and <a
     * href="GetOrderTransactions.html">GetOrderTransactions</a> to retrieve the order. | A unique identifier for an order.
     * - minOccurs: 0
     * @var string
     */
    public $OrderID;
    /**
     * The CreatedTime
     * Meta informations extracted from the WSDL
     * - documentation: Timestamp that indicates the date and time that the Combined Invoice order was created.
     * - minOccurs: 0
     * @var string
     */
    public $CreatedTime;
    /**
     * Constructor method for AddOrderResponseType
     * @uses AddOrderResponseType::setOrderID()
     * @uses AddOrderResponseType::setCreatedTime()
     * @param string $orderID
     * @param string $createdTime
     */
    public function __construct($orderID = null, $createdTime = null)
    {
        $this
            ->setOrderID($orderID)
            ->setCreatedTime($createdTime);
    }
    /**
     * Get OrderID value
     * @return string|null
     */
    public function getOrderID()
    {
        return $this->OrderID;
    }
    /**
     * Set OrderID value
     * @param string $orderID
     * @return \StructType\AddOrderResponseType
     */
    public function setOrderID($orderID = null)
    {
        // validation for constraint: string
        if (!is_null($orderID) && !is_string($orderID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($orderID)), __LINE__);
        }
        $this->OrderID = $orderID;
        return $this;
    }
    /**
     * Get CreatedTime value
     * @return string|null
     */
    public function getCreatedTime()
    {
        return $this->CreatedTime;
    }
    /**
     * Set CreatedTime value
     * @param string $createdTime
     * @return \StructType\AddOrderResponseType
     */
    public function setCreatedTime($createdTime = null)
    {
        // validation for constraint: string
        if (!is_null($createdTime) && !is_string($createdTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($createdTime)), __LINE__);
        }
        $this->CreatedTime = $createdTime;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AddOrderResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
