<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ItemTransactionIDArrayType ArrayType
 * Meta informations extracted from the WSDL
 * - documentation: Container of ItemTransactionIDs.
 * @subpackage Arrays
 */
class ItemTransactionIDArrayType extends AbstractStructArrayBase
{
    /**
     * The ItemTransactionID
     * Meta informations extracted from the WSDL
     * - documentation: An ItemID-TransactionID container. Note: OrderID is not returned when the GetOrderTransactions request includes ItemTransactionID, even if the transaction is part of an order. To get the OrderID for a transaction, call
     * GetItemTransaction with IncludeContainingOrder = true.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItemTransactionIDType[]
     */
    public $ItemTransactionID;
    /**
     * Constructor method for ItemTransactionIDArrayType
     * @uses ItemTransactionIDArrayType::setItemTransactionID()
     * @param \StructType\ItemTransactionIDType[] $itemTransactionID
     */
    public function __construct(array $itemTransactionID = array())
    {
        $this
            ->setItemTransactionID($itemTransactionID);
    }
    /**
     * Get ItemTransactionID value
     * @return \StructType\ItemTransactionIDType[]|null
     */
    public function getItemTransactionID()
    {
        return $this->ItemTransactionID;
    }
    /**
     * Set ItemTransactionID value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemTransactionIDType[] $itemTransactionID
     * @return \ArrayType\ItemTransactionIDArrayType
     */
    public function setItemTransactionID(array $itemTransactionID = array())
    {
        foreach ($itemTransactionID as $itemTransactionIDArrayTypeItemTransactionIDItem) {
            // validation for constraint: itemType
            if (!$itemTransactionIDArrayTypeItemTransactionIDItem instanceof \StructType\ItemTransactionIDType) {
                throw new \InvalidArgumentException(sprintf('The ItemTransactionID property can only contain items of \StructType\ItemTransactionIDType, "%s" given', is_object($itemTransactionIDArrayTypeItemTransactionIDItem) ? get_class($itemTransactionIDArrayTypeItemTransactionIDItem) : gettype($itemTransactionIDArrayTypeItemTransactionIDItem)), __LINE__);
            }
        }
        $this->ItemTransactionID = $itemTransactionID;
        return $this;
    }
    /**
     * Add item to ItemTransactionID value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemTransactionIDType $item
     * @return \ArrayType\ItemTransactionIDArrayType
     */
    public function addToItemTransactionID(\StructType\ItemTransactionIDType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemTransactionIDType) {
            throw new \InvalidArgumentException(sprintf('The ItemTransactionID property can only contain items of \StructType\ItemTransactionIDType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ItemTransactionID[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ItemTransactionIDType|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ItemTransactionIDType|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ItemTransactionIDType|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ItemTransactionIDType|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ItemTransactionIDType|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ItemTransactionID
     */
    public function getAttributeName()
    {
        return 'ItemTransactionID';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ItemTransactionIDArrayType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
