<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PlaceOfferRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Enables the authenticated user to to make a bid, a best offer, or a purchase on the item specified by the ItemID input field.
 * @subpackage Structs
 */
class PlaceOfferRequestType extends AbstractRequestType
{
    /**
     * The Offer
     * Meta informations extracted from the WSDL
     * - documentation: Specifies the type of offer being made. If the item is a competitive-bidding listing, the offer is a bid. If the item is a fixed-price listing, then the offer purchases the item. If the item is a competitive-bidding listing and the
     * offer is of type with an active, unexercised Buy It Now option, then the offer can either purchase the item or be a bid. See the schema documentation for OfferType for details on its properties and their meanings.
     * - minOccurs: 0
     * @var \StructType\OfferType
     */
    public $Offer;
    /**
     * The ItemID
     * Meta informations extracted from the WSDL
     * - documentation: Unique item ID that identifies the item listing for which the action is being submitted. <br><br> If the item was listed with Variations, you must also specify VariationSpecifics in the request to uniquely identify the variant being
     * purchased. | Type that represents the unique identifier for a single item listing.
     * - minOccurs: 0
     * @var string
     */
    public $ItemID;
    /**
     * The BlockOnWarning
     * Meta informations extracted from the WSDL
     * - documentation: If a warning message exists and BlockOnWarning is true, the warning message is returned and the bid is blocked. If no warning message exists and BlockOnWarning is true, the bid is placed. If BlockOnWarning is false, the bid is
     * placed, regardless of warning.
     * - minOccurs: 0
     * @var bool
     */
    public $BlockOnWarning;
    /**
     * The AffiliateTrackingDetails
     * Meta informations extracted from the WSDL
     * - documentation: Container for affiliate-related tags, which enable the tracking of user activity. If you include AffiliateTrackingDetails in your PlaceOffer call, then it is possible to receive affiliate commissions based on calls made by your
     * application. (See the <a href= "http://www.ebaypartnernetwork.com/" target="_blank">eBay Partner Network</a> for information about commissions.) Please note that affiliate tracking is not available in the Sandbox environment, and that affiliate
     * tracking is not available when you make a best offer.
     * - minOccurs: 0
     * @var \StructType\AffiliateTrackingDetailsType
     */
    public $AffiliateTrackingDetails;
    /**
     * The VariationSpecifics
     * Meta informations extracted from the WSDL
     * - documentation: Name-value pairs that identify a single variation within the listing identified by ItemID. Required when the seller listed the item with Item Variations.<br> <br> If you want to buy items from multiple variations in the same listing,
     * use a separate PlaceOffer request for each variation. For example, if you want to buy 3 red shirts and 2 black shirts from the same listing, use one PlaceOffer request for the 3 red shirts, and another PlaceOffer request for the 2 black shirts.
     * - minOccurs: 0
     * @var \ArrayType\NameValueListArrayType
     */
    public $VariationSpecifics;
    /**
     * Constructor method for PlaceOfferRequestType
     * @uses PlaceOfferRequestType::setOffer()
     * @uses PlaceOfferRequestType::setItemID()
     * @uses PlaceOfferRequestType::setBlockOnWarning()
     * @uses PlaceOfferRequestType::setAffiliateTrackingDetails()
     * @uses PlaceOfferRequestType::setVariationSpecifics()
     * @param \StructType\OfferType $offer
     * @param string $itemID
     * @param bool $blockOnWarning
     * @param \StructType\AffiliateTrackingDetailsType $affiliateTrackingDetails
     * @param \ArrayType\NameValueListArrayType $variationSpecifics
     */
    public function __construct(\StructType\OfferType $offer = null, $itemID = null, $blockOnWarning = null, \StructType\AffiliateTrackingDetailsType $affiliateTrackingDetails = null, \ArrayType\NameValueListArrayType $variationSpecifics = null)
    {
        $this
            ->setOffer($offer)
            ->setItemID($itemID)
            ->setBlockOnWarning($blockOnWarning)
            ->setAffiliateTrackingDetails($affiliateTrackingDetails)
            ->setVariationSpecifics($variationSpecifics);
    }
    /**
     * Get Offer value
     * @return \StructType\OfferType|null
     */
    public function getOffer()
    {
        return $this->Offer;
    }
    /**
     * Set Offer value
     * @param \StructType\OfferType $offer
     * @return \StructType\PlaceOfferRequestType
     */
    public function setOffer(\StructType\OfferType $offer = null)
    {
        $this->Offer = $offer;
        return $this;
    }
    /**
     * Get ItemID value
     * @return string|null
     */
    public function getItemID()
    {
        return $this->ItemID;
    }
    /**
     * Set ItemID value
     * @param string $itemID
     * @return \StructType\PlaceOfferRequestType
     */
    public function setItemID($itemID = null)
    {
        // validation for constraint: string
        if (!is_null($itemID) && !is_string($itemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemID)), __LINE__);
        }
        $this->ItemID = $itemID;
        return $this;
    }
    /**
     * Get BlockOnWarning value
     * @return bool|null
     */
    public function getBlockOnWarning()
    {
        return $this->BlockOnWarning;
    }
    /**
     * Set BlockOnWarning value
     * @param bool $blockOnWarning
     * @return \StructType\PlaceOfferRequestType
     */
    public function setBlockOnWarning($blockOnWarning = null)
    {
        $this->BlockOnWarning = $blockOnWarning;
        return $this;
    }
    /**
     * Get AffiliateTrackingDetails value
     * @return \StructType\AffiliateTrackingDetailsType|null
     */
    public function getAffiliateTrackingDetails()
    {
        return $this->AffiliateTrackingDetails;
    }
    /**
     * Set AffiliateTrackingDetails value
     * @param \StructType\AffiliateTrackingDetailsType $affiliateTrackingDetails
     * @return \StructType\PlaceOfferRequestType
     */
    public function setAffiliateTrackingDetails(\StructType\AffiliateTrackingDetailsType $affiliateTrackingDetails = null)
    {
        $this->AffiliateTrackingDetails = $affiliateTrackingDetails;
        return $this;
    }
    /**
     * Get VariationSpecifics value
     * @return \ArrayType\NameValueListArrayType|null
     */
    public function getVariationSpecifics()
    {
        return $this->VariationSpecifics;
    }
    /**
     * Set VariationSpecifics value
     * @param \ArrayType\NameValueListArrayType $variationSpecifics
     * @return \StructType\PlaceOfferRequestType
     */
    public function setVariationSpecifics(\ArrayType\NameValueListArrayType $variationSpecifics = null)
    {
        $this->VariationSpecifics = $variationSpecifics;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PlaceOfferRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
