<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetSellerPaymentsResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Returns a summary of pending or paid payments that Half.com created for the seller identified by the authentication token in the request. Only returns payments that occurred within a particular pay period. <br/><br/> Each payment is
 * for one transaction for one item in one order. An order can contain transactions for multiple items from multiple sellers, but this call only retrieves payments that are relevant to one seller. <br/><br/> Payments are only issued for items and
 * transactions that the seller has confirmed (see the Half.com online help for details). The financial value of a payment is typically based on an amount that a buyer paid to Half.com for a transaction, plus the shipping cost the buyer paid to Half.com
 * for the item, minus Half.com's commission. <br/><br/> For most sellers, each month contains two pay periods: One from the 1st to the 15th of the month, and one from the 16th to the last day of the month. Payments are submitted to the seller's
 * financial institution a certain number of days after the current pay period ends (see the Half.com online help for details).
 * @subpackage Structs
 */
class GetSellerPaymentsResponseType extends AbstractResponseType
{
    /**
     * The PaginationResult
     * Meta informations extracted from the WSDL
     * - documentation: Contains information regarding the pagination of data (if pagination is used), including total number of pages and total number of entries.
     * - minOccurs: 0
     * @var \StructType\PaginationResultType
     */
    public $PaginationResult;
    /**
     * The HasMorePayments
     * Meta informations extracted from the WSDL
     * - documentation: If true, there are more payments yet to be retrieved. Additional <b>GetSellerPayments</b> calls with higher page numbers or more entries per page must be made to retrieve these payments. If false, no more payments are available or no
     * payments match the request (based on the payment status and time filter).
     * - minOccurs: 0
     * @var bool
     */
    public $HasMorePayments;
    /**
     * The SellerPayment
     * Meta informations extracted from the WSDL
     * - documentation: Information about a single payment that matches the criteria in the request. A payment is between Half.com and a seller. <br/><br/> Each payment is for one transaction for one item in one order. An order can contain transactions for
     * multiple items from multiple sellers, but this call only retrieves payments that are relevant to one seller. The financial value of a payment is typically based on an amount that a buyer paid to Half.com for a transaction, plus the shipping cost the
     * buyer paid for the item, minus Half.com's commission. <br/><br/> Payments can also describe refunds that the seller has issued. Multiple <b>SellerPayment</b> entries can be returned per page of results. Typically, they are returned in reverse
     * chronological order (most recent <b>PaidTime</b> first). Only returned if payments exist that match the request.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SellerPaymentType[]
     */
    public $SellerPayment;
    /**
     * The PaymentsPerPage
     * Meta informations extracted from the WSDL
     * - documentation: Indicates the number of payments that can be returned per page of data (i.e., per call). This is the same as the value specified in the <b>Pagination.EntriesPerPage</b> input (or the default value, if <b>EntriesPerPage</b> was not
     * specified). This is not necessarily the actual number of payments returned per page (see <b>ReturnedPaymentCountActual</b>).
     * - minOccurs: 0
     * @var int
     */
    public $PaymentsPerPage;
    /**
     * The PageNumber
     * Meta informations extracted from the WSDL
     * - documentation: Indicates which page of data holds the current result set. Will be the same as the value specified in the <b>Pagination.PageNumber</b> input. (If the input is higher than the total number of pages, the call fails with an error.) If
     * no payments are returned, the value is 0. If payments are returned, the first page number is 1.
     * - minOccurs: 0
     * @var int
     */
    public $PageNumber;
    /**
     * The ReturnedPaymentCountActual
     * Meta informations extracted from the WSDL
     * - documentation: Indicates the total number of payments returned (i.e., the number of <b>SellerPayment</b> entries returned.
     * - minOccurs: 0
     * @var int
     */
    public $ReturnedPaymentCountActual;
    /**
     * Constructor method for GetSellerPaymentsResponseType
     * @uses GetSellerPaymentsResponseType::setPaginationResult()
     * @uses GetSellerPaymentsResponseType::setHasMorePayments()
     * @uses GetSellerPaymentsResponseType::setSellerPayment()
     * @uses GetSellerPaymentsResponseType::setPaymentsPerPage()
     * @uses GetSellerPaymentsResponseType::setPageNumber()
     * @uses GetSellerPaymentsResponseType::setReturnedPaymentCountActual()
     * @param \StructType\PaginationResultType $paginationResult
     * @param bool $hasMorePayments
     * @param \StructType\SellerPaymentType[] $sellerPayment
     * @param int $paymentsPerPage
     * @param int $pageNumber
     * @param int $returnedPaymentCountActual
     */
    public function __construct(\StructType\PaginationResultType $paginationResult = null, $hasMorePayments = null, array $sellerPayment = array(), $paymentsPerPage = null, $pageNumber = null, $returnedPaymentCountActual = null)
    {
        $this
            ->setPaginationResult($paginationResult)
            ->setHasMorePayments($hasMorePayments)
            ->setSellerPayment($sellerPayment)
            ->setPaymentsPerPage($paymentsPerPage)
            ->setPageNumber($pageNumber)
            ->setReturnedPaymentCountActual($returnedPaymentCountActual);
    }
    /**
     * Get PaginationResult value
     * @return \StructType\PaginationResultType|null
     */
    public function getPaginationResult()
    {
        return $this->PaginationResult;
    }
    /**
     * Set PaginationResult value
     * @param \StructType\PaginationResultType $paginationResult
     * @return \StructType\GetSellerPaymentsResponseType
     */
    public function setPaginationResult(\StructType\PaginationResultType $paginationResult = null)
    {
        $this->PaginationResult = $paginationResult;
        return $this;
    }
    /**
     * Get HasMorePayments value
     * @return bool|null
     */
    public function getHasMorePayments()
    {
        return $this->HasMorePayments;
    }
    /**
     * Set HasMorePayments value
     * @param bool $hasMorePayments
     * @return \StructType\GetSellerPaymentsResponseType
     */
    public function setHasMorePayments($hasMorePayments = null)
    {
        $this->HasMorePayments = $hasMorePayments;
        return $this;
    }
    /**
     * Get SellerPayment value
     * @return \StructType\SellerPaymentType[]|null
     */
    public function getSellerPayment()
    {
        return $this->SellerPayment;
    }
    /**
     * Set SellerPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\SellerPaymentType[] $sellerPayment
     * @return \StructType\GetSellerPaymentsResponseType
     */
    public function setSellerPayment(array $sellerPayment = array())
    {
        foreach ($sellerPayment as $getSellerPaymentsResponseTypeSellerPaymentItem) {
            // validation for constraint: itemType
            if (!$getSellerPaymentsResponseTypeSellerPaymentItem instanceof \StructType\SellerPaymentType) {
                throw new \InvalidArgumentException(sprintf('The SellerPayment property can only contain items of \StructType\SellerPaymentType, "%s" given', is_object($getSellerPaymentsResponseTypeSellerPaymentItem) ? get_class($getSellerPaymentsResponseTypeSellerPaymentItem) : gettype($getSellerPaymentsResponseTypeSellerPaymentItem)), __LINE__);
            }
        }
        $this->SellerPayment = $sellerPayment;
        return $this;
    }
    /**
     * Add item to SellerPayment value
     * @throws \InvalidArgumentException
     * @param \StructType\SellerPaymentType $item
     * @return \StructType\GetSellerPaymentsResponseType
     */
    public function addToSellerPayment(\StructType\SellerPaymentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SellerPaymentType) {
            throw new \InvalidArgumentException(sprintf('The SellerPayment property can only contain items of \StructType\SellerPaymentType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SellerPayment[] = $item;
        return $this;
    }
    /**
     * Get PaymentsPerPage value
     * @return int|null
     */
    public function getPaymentsPerPage()
    {
        return $this->PaymentsPerPage;
    }
    /**
     * Set PaymentsPerPage value
     * @param int $paymentsPerPage
     * @return \StructType\GetSellerPaymentsResponseType
     */
    public function setPaymentsPerPage($paymentsPerPage = null)
    {
        // validation for constraint: int
        if (!is_null($paymentsPerPage) && !is_numeric($paymentsPerPage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($paymentsPerPage)), __LINE__);
        }
        $this->PaymentsPerPage = $paymentsPerPage;
        return $this;
    }
    /**
     * Get PageNumber value
     * @return int|null
     */
    public function getPageNumber()
    {
        return $this->PageNumber;
    }
    /**
     * Set PageNumber value
     * @param int $pageNumber
     * @return \StructType\GetSellerPaymentsResponseType
     */
    public function setPageNumber($pageNumber = null)
    {
        // validation for constraint: int
        if (!is_null($pageNumber) && !is_numeric($pageNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($pageNumber)), __LINE__);
        }
        $this->PageNumber = $pageNumber;
        return $this;
    }
    /**
     * Get ReturnedPaymentCountActual value
     * @return int|null
     */
    public function getReturnedPaymentCountActual()
    {
        return $this->ReturnedPaymentCountActual;
    }
    /**
     * Set ReturnedPaymentCountActual value
     * @param int $returnedPaymentCountActual
     * @return \StructType\GetSellerPaymentsResponseType
     */
    public function setReturnedPaymentCountActual($returnedPaymentCountActual = null)
    {
        // validation for constraint: int
        if (!is_null($returnedPaymentCountActual) && !is_numeric($returnedPaymentCountActual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($returnedPaymentCountActual)), __LINE__);
        }
        $this->ReturnedPaymentCountActual = $returnedPaymentCountActual;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetSellerPaymentsResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
