<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMyeBaySellingRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Retrieves information regarding the user's selling activity, such as items that the user is currently selling (the Active list), items that have bids, sold items, and unsold items.
 * @subpackage Structs
 */
class GetMyeBaySellingRequestType extends AbstractRequestType
{
    /**
     * The ScheduledList
     * Meta informations extracted from the WSDL
     * - documentation: Returns the list of items the user has scheduled to sell but whose listings have not yet opened. <br><br> Set <b>Include</b> to <code>true</code> to return the default response set.
     * - minOccurs: 0
     * @var \StructType\ItemListCustomizationType
     */
    public $ScheduledList;
    /**
     * The ActiveList
     * Meta informations extracted from the WSDL
     * - documentation: Returns the list of items the user is actively selling (the currently active listings). <br><br> Set <b>Include</b> to <code>true</code> to return the default response set.
     * - minOccurs: 0
     * @var \StructType\ItemListCustomizationType
     */
    public $ActiveList;
    /**
     * The SoldList
     * Meta informations extracted from the WSDL
     * - documentation: Returns the list of items the user has sold. <br><br> Set <b>Include</b> to <code>true</code> to return the default response set.
     * - minOccurs: 0
     * @var \StructType\ItemListCustomizationType
     */
    public $SoldList;
    /**
     * The UnsoldList
     * Meta informations extracted from the WSDL
     * - documentation: Returns the list of items the user has listed, but whose listings have ended without being sold. <br><br> Set <b>Include</b> to <code>true</code> to return the default response set.
     * - minOccurs: 0
     * @var \StructType\ItemListCustomizationType
     */
    public $UnsoldList;
    /**
     * The BidList
     * Meta informations extracted from the WSDL
     * - documentation: Return the list of active items on which there are bids. <br><br> Set Include to true to return the default response set.
     * - minOccurs: 0
     * @var \StructType\ItemListCustomizationType
     */
    public $BidList;
    /**
     * The DeletedFromSoldList
     * Meta informations extracted from the WSDL
     * - documentation: Returns the list of items the user sold, and then deleted from their My eBay page. Allowed values for DurationInDays are 0-90. <br><br> Set <b>Include</b> to <code>true</code> to return the default response set.
     * - minOccurs: 0
     * @var \StructType\ItemListCustomizationType
     */
    public $DeletedFromSoldList;
    /**
     * The DeletedFromUnsoldList
     * Meta informations extracted from the WSDL
     * - documentation: Returns the list of items the user either ended or did not sell, and subsequently were deleted them from their My eBay page. Allowed values for DurationInDays are 0-90. <br><br> Set <b>Include</b> to <code>true</code> to return the
     * default response set.
     * - minOccurs: 0
     * @var \StructType\ItemListCustomizationType
     */
    public $DeletedFromUnsoldList;
    /**
     * The SellingSummary
     * Meta informations extracted from the WSDL
     * - documentation: Returns a summary of the user's buying activity. <br><br> The <b>SellingSummary</b> is always returned by default. Add a <b>SellingSummary</b> element with an <b>Include</b> field set to false to exclude the <b>SellingSummary</b>
     * from your response.
     * - minOccurs: 0
     * @var \StructType\ItemListCustomizationType
     */
    public $SellingSummary;
    /**
     * The HideVariations
     * Meta informations extracted from the WSDL
     * - documentation: If true, the <b>Variations</b> node is omitted for all multi-variation listings in the response. If false, the <b>Variations</b> node is returned for all multi-variation listings in the response. <br> <br> Please note that if the
     * seller includes a large number of variations in many listings, retrieving variations (setting this flag to <code>false</code>) may degrade the call's performance. Therefore, when this is false, you may need to reduce the total number of items you're
     * requesting at once (by using other input fields, such as <b>Pagination</b>).
     * - minOccurs: 0
     * @var bool
     */
    public $HideVariations;
    /**
     * Constructor method for GetMyeBaySellingRequestType
     * @uses GetMyeBaySellingRequestType::setScheduledList()
     * @uses GetMyeBaySellingRequestType::setActiveList()
     * @uses GetMyeBaySellingRequestType::setSoldList()
     * @uses GetMyeBaySellingRequestType::setUnsoldList()
     * @uses GetMyeBaySellingRequestType::setBidList()
     * @uses GetMyeBaySellingRequestType::setDeletedFromSoldList()
     * @uses GetMyeBaySellingRequestType::setDeletedFromUnsoldList()
     * @uses GetMyeBaySellingRequestType::setSellingSummary()
     * @uses GetMyeBaySellingRequestType::setHideVariations()
     * @param \StructType\ItemListCustomizationType $scheduledList
     * @param \StructType\ItemListCustomizationType $activeList
     * @param \StructType\ItemListCustomizationType $soldList
     * @param \StructType\ItemListCustomizationType $unsoldList
     * @param \StructType\ItemListCustomizationType $bidList
     * @param \StructType\ItemListCustomizationType $deletedFromSoldList
     * @param \StructType\ItemListCustomizationType $deletedFromUnsoldList
     * @param \StructType\ItemListCustomizationType $sellingSummary
     * @param bool $hideVariations
     */
    public function __construct(\StructType\ItemListCustomizationType $scheduledList = null, \StructType\ItemListCustomizationType $activeList = null, \StructType\ItemListCustomizationType $soldList = null, \StructType\ItemListCustomizationType $unsoldList = null, \StructType\ItemListCustomizationType $bidList = null, \StructType\ItemListCustomizationType $deletedFromSoldList = null, \StructType\ItemListCustomizationType $deletedFromUnsoldList = null, \StructType\ItemListCustomizationType $sellingSummary = null, $hideVariations = null)
    {
        $this
            ->setScheduledList($scheduledList)
            ->setActiveList($activeList)
            ->setSoldList($soldList)
            ->setUnsoldList($unsoldList)
            ->setBidList($bidList)
            ->setDeletedFromSoldList($deletedFromSoldList)
            ->setDeletedFromUnsoldList($deletedFromUnsoldList)
            ->setSellingSummary($sellingSummary)
            ->setHideVariations($hideVariations);
    }
    /**
     * Get ScheduledList value
     * @return \StructType\ItemListCustomizationType|null
     */
    public function getScheduledList()
    {
        return $this->ScheduledList;
    }
    /**
     * Set ScheduledList value
     * @param \StructType\ItemListCustomizationType $scheduledList
     * @return \StructType\GetMyeBaySellingRequestType
     */
    public function setScheduledList(\StructType\ItemListCustomizationType $scheduledList = null)
    {
        $this->ScheduledList = $scheduledList;
        return $this;
    }
    /**
     * Get ActiveList value
     * @return \StructType\ItemListCustomizationType|null
     */
    public function getActiveList()
    {
        return $this->ActiveList;
    }
    /**
     * Set ActiveList value
     * @param \StructType\ItemListCustomizationType $activeList
     * @return \StructType\GetMyeBaySellingRequestType
     */
    public function setActiveList(\StructType\ItemListCustomizationType $activeList = null)
    {
        $this->ActiveList = $activeList;
        return $this;
    }
    /**
     * Get SoldList value
     * @return \StructType\ItemListCustomizationType|null
     */
    public function getSoldList()
    {
        return $this->SoldList;
    }
    /**
     * Set SoldList value
     * @param \StructType\ItemListCustomizationType $soldList
     * @return \StructType\GetMyeBaySellingRequestType
     */
    public function setSoldList(\StructType\ItemListCustomizationType $soldList = null)
    {
        $this->SoldList = $soldList;
        return $this;
    }
    /**
     * Get UnsoldList value
     * @return \StructType\ItemListCustomizationType|null
     */
    public function getUnsoldList()
    {
        return $this->UnsoldList;
    }
    /**
     * Set UnsoldList value
     * @param \StructType\ItemListCustomizationType $unsoldList
     * @return \StructType\GetMyeBaySellingRequestType
     */
    public function setUnsoldList(\StructType\ItemListCustomizationType $unsoldList = null)
    {
        $this->UnsoldList = $unsoldList;
        return $this;
    }
    /**
     * Get BidList value
     * @return \StructType\ItemListCustomizationType|null
     */
    public function getBidList()
    {
        return $this->BidList;
    }
    /**
     * Set BidList value
     * @param \StructType\ItemListCustomizationType $bidList
     * @return \StructType\GetMyeBaySellingRequestType
     */
    public function setBidList(\StructType\ItemListCustomizationType $bidList = null)
    {
        $this->BidList = $bidList;
        return $this;
    }
    /**
     * Get DeletedFromSoldList value
     * @return \StructType\ItemListCustomizationType|null
     */
    public function getDeletedFromSoldList()
    {
        return $this->DeletedFromSoldList;
    }
    /**
     * Set DeletedFromSoldList value
     * @param \StructType\ItemListCustomizationType $deletedFromSoldList
     * @return \StructType\GetMyeBaySellingRequestType
     */
    public function setDeletedFromSoldList(\StructType\ItemListCustomizationType $deletedFromSoldList = null)
    {
        $this->DeletedFromSoldList = $deletedFromSoldList;
        return $this;
    }
    /**
     * Get DeletedFromUnsoldList value
     * @return \StructType\ItemListCustomizationType|null
     */
    public function getDeletedFromUnsoldList()
    {
        return $this->DeletedFromUnsoldList;
    }
    /**
     * Set DeletedFromUnsoldList value
     * @param \StructType\ItemListCustomizationType $deletedFromUnsoldList
     * @return \StructType\GetMyeBaySellingRequestType
     */
    public function setDeletedFromUnsoldList(\StructType\ItemListCustomizationType $deletedFromUnsoldList = null)
    {
        $this->DeletedFromUnsoldList = $deletedFromUnsoldList;
        return $this;
    }
    /**
     * Get SellingSummary value
     * @return \StructType\ItemListCustomizationType|null
     */
    public function getSellingSummary()
    {
        return $this->SellingSummary;
    }
    /**
     * Set SellingSummary value
     * @param \StructType\ItemListCustomizationType $sellingSummary
     * @return \StructType\GetMyeBaySellingRequestType
     */
    public function setSellingSummary(\StructType\ItemListCustomizationType $sellingSummary = null)
    {
        $this->SellingSummary = $sellingSummary;
        return $this;
    }
    /**
     * Get HideVariations value
     * @return bool|null
     */
    public function getHideVariations()
    {
        return $this->HideVariations;
    }
    /**
     * Set HideVariations value
     * @param bool $hideVariations
     * @return \StructType\GetMyeBaySellingRequestType
     */
    public function setHideVariations($hideVariations = null)
    {
        $this->HideVariations = $hideVariations;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetMyeBaySellingRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
