<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetMyeBayBuyingResponseType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Returns information regarding a user's buying activity, such as items they are watching, bidding on, have won, did not win, and have made Best Offers on.
 * @subpackage Structs
 */
class GetMyeBayBuyingResponseType extends AbstractResponseType
{
    /**
     * The BuyingSummary
     * Meta informations extracted from the WSDL
     * - documentation: Contains a summary of the items the user has bid on. Returned at all detail levels.
     * - minOccurs: 0
     * @var \StructType\BuyingSummaryType
     */
    public $BuyingSummary;
    /**
     * The WatchList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items the user is watching. Only returned if items exist that meet the request criteria.
     * - minOccurs: 0
     * @var \StructType\PaginatedItemArrayType
     */
    public $WatchList;
    /**
     * The BidList
     * Meta informations extracted from the WSDL
     * - documentation: Contains all the items the buyer has bid on. Only returned if items exist that meet the request criteria.
     * - minOccurs: 0
     * @var \StructType\PaginatedItemArrayType
     */
    public $BidList;
    /**
     * The BestOfferList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items the user has placed Best Offers on. Only returned if items exist that meet the request criteria.
     * - minOccurs: 0
     * @var \StructType\PaginatedItemArrayType
     */
    public $BestOfferList;
    /**
     * The WonList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items the user has bid on and won. Only returned if items exist that meet the request criteria.
     * - minOccurs: 0
     * @var \StructType\PaginatedOrderTransactionArrayType
     */
    public $WonList;
    /**
     * The LostList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items the user has bid on and lost. Only returned if items exist that meet the request criteria.
     * - minOccurs: 0
     * @var \StructType\PaginatedItemArrayType
     */
    public $LostList;
    /**
     * The FavoriteSearches
     * Meta informations extracted from the WSDL
     * - documentation: Contains a list of the user's favorite searches. Only returned if the user has Favorite Searches. The search name, search query, and search elements, such as QueryKeywords, SortOrder, and Condition are returned. <br><br> You can
     * paste the Search Query response, that comes back as a URL, into a browser to re-play the Favorite Search. <br><br> The search elements that are returned by this call can be used as input for the Shopping Web Service FindItemsAdvanced request.
     * - minOccurs: 0
     * @var \StructType\MyeBayFavoriteSearchListType
     */
    public $FavoriteSearches;
    /**
     * The FavoriteSellers
     * Meta informations extracted from the WSDL
     * - documentation: Contains a list of the user's favorite sellers. Only returned if items exist that meet the request criteria.
     * - minOccurs: 0
     * @var \StructType\MyeBayFavoriteSellerListType
     */
    public $FavoriteSellers;
    /**
     * The SecondChanceOffer
     * Meta informations extracted from the WSDL
     * - documentation: Contains the list of Second Chance Offers the user has received. Only returned if items exist that meet the request criteria.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ItemType[]
     */
    public $SecondChanceOffer;
    /**
     * The BidAssistantList
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var \ArrayType\BidGroupArrayType
     */
    public $BidAssistantList;
    /**
     * The DeletedFromWonList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items the buyer has bid on, won, and deleted from My eBay. Only returned if items exist that meet the request criteria.
     * - minOccurs: 0
     * @var \StructType\PaginatedOrderTransactionArrayType
     */
    public $DeletedFromWonList;
    /**
     * The DeletedFromLostList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items the buyer has bid on, lost, and deleted from My eBay. Only returned if items exist that meet the request criteria.
     * - minOccurs: 0
     * @var \StructType\PaginatedItemArrayType
     */
    public $DeletedFromLostList;
    /**
     * The UserDefinedList
     * Meta informations extracted from the WSDL
     * - documentation: Contains the items, searches, or sellers that the user has saved to this list using the "Add to list" feature. The name of the list is given by the "Name" element. Returned only if UserDefineLists is specified in the request.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\UserDefinedListType[]
     */
    public $UserDefinedList;
    /**
     * Constructor method for GetMyeBayBuyingResponseType
     * @uses GetMyeBayBuyingResponseType::setBuyingSummary()
     * @uses GetMyeBayBuyingResponseType::setWatchList()
     * @uses GetMyeBayBuyingResponseType::setBidList()
     * @uses GetMyeBayBuyingResponseType::setBestOfferList()
     * @uses GetMyeBayBuyingResponseType::setWonList()
     * @uses GetMyeBayBuyingResponseType::setLostList()
     * @uses GetMyeBayBuyingResponseType::setFavoriteSearches()
     * @uses GetMyeBayBuyingResponseType::setFavoriteSellers()
     * @uses GetMyeBayBuyingResponseType::setSecondChanceOffer()
     * @uses GetMyeBayBuyingResponseType::setBidAssistantList()
     * @uses GetMyeBayBuyingResponseType::setDeletedFromWonList()
     * @uses GetMyeBayBuyingResponseType::setDeletedFromLostList()
     * @uses GetMyeBayBuyingResponseType::setUserDefinedList()
     * @param \StructType\BuyingSummaryType $buyingSummary
     * @param \StructType\PaginatedItemArrayType $watchList
     * @param \StructType\PaginatedItemArrayType $bidList
     * @param \StructType\PaginatedItemArrayType $bestOfferList
     * @param \StructType\PaginatedOrderTransactionArrayType $wonList
     * @param \StructType\PaginatedItemArrayType $lostList
     * @param \StructType\MyeBayFavoriteSearchListType $favoriteSearches
     * @param \StructType\MyeBayFavoriteSellerListType $favoriteSellers
     * @param \StructType\ItemType[] $secondChanceOffer
     * @param \ArrayType\BidGroupArrayType $bidAssistantList
     * @param \StructType\PaginatedOrderTransactionArrayType $deletedFromWonList
     * @param \StructType\PaginatedItemArrayType $deletedFromLostList
     * @param \StructType\UserDefinedListType[] $userDefinedList
     */
    public function __construct(\StructType\BuyingSummaryType $buyingSummary = null, \StructType\PaginatedItemArrayType $watchList = null, \StructType\PaginatedItemArrayType $bidList = null, \StructType\PaginatedItemArrayType $bestOfferList = null, \StructType\PaginatedOrderTransactionArrayType $wonList = null, \StructType\PaginatedItemArrayType $lostList = null, \StructType\MyeBayFavoriteSearchListType $favoriteSearches = null, \StructType\MyeBayFavoriteSellerListType $favoriteSellers = null, array $secondChanceOffer = array(), \ArrayType\BidGroupArrayType $bidAssistantList = null, \StructType\PaginatedOrderTransactionArrayType $deletedFromWonList = null, \StructType\PaginatedItemArrayType $deletedFromLostList = null, array $userDefinedList = array())
    {
        $this
            ->setBuyingSummary($buyingSummary)
            ->setWatchList($watchList)
            ->setBidList($bidList)
            ->setBestOfferList($bestOfferList)
            ->setWonList($wonList)
            ->setLostList($lostList)
            ->setFavoriteSearches($favoriteSearches)
            ->setFavoriteSellers($favoriteSellers)
            ->setSecondChanceOffer($secondChanceOffer)
            ->setBidAssistantList($bidAssistantList)
            ->setDeletedFromWonList($deletedFromWonList)
            ->setDeletedFromLostList($deletedFromLostList)
            ->setUserDefinedList($userDefinedList);
    }
    /**
     * Get BuyingSummary value
     * @return \StructType\BuyingSummaryType|null
     */
    public function getBuyingSummary()
    {
        return $this->BuyingSummary;
    }
    /**
     * Set BuyingSummary value
     * @param \StructType\BuyingSummaryType $buyingSummary
     * @return \StructType\GetMyeBayBuyingResponseType
     */
    public function setBuyingSummary(\StructType\BuyingSummaryType $buyingSummary = null)
    {
        $this->BuyingSummary = $buyingSummary;
        return $this;
    }
    /**
     * Get WatchList value
     * @return \StructType\PaginatedItemArrayType|null
     */
    public function getWatchList()
    {
        return $this->WatchList;
    }
    /**
     * Set WatchList value
     * @param \StructType\PaginatedItemArrayType $watchList
     * @return \StructType\GetMyeBayBuyingResponseType
     */
    public function setWatchList(\StructType\PaginatedItemArrayType $watchList = null)
    {
        $this->WatchList = $watchList;
        return $this;
    }
    /**
     * Get BidList value
     * @return \StructType\PaginatedItemArrayType|null
     */
    public function getBidList()
    {
        return $this->BidList;
    }
    /**
     * Set BidList value
     * @param \StructType\PaginatedItemArrayType $bidList
     * @return \StructType\GetMyeBayBuyingResponseType
     */
    public function setBidList(\StructType\PaginatedItemArrayType $bidList = null)
    {
        $this->BidList = $bidList;
        return $this;
    }
    /**
     * Get BestOfferList value
     * @return \StructType\PaginatedItemArrayType|null
     */
    public function getBestOfferList()
    {
        return $this->BestOfferList;
    }
    /**
     * Set BestOfferList value
     * @param \StructType\PaginatedItemArrayType $bestOfferList
     * @return \StructType\GetMyeBayBuyingResponseType
     */
    public function setBestOfferList(\StructType\PaginatedItemArrayType $bestOfferList = null)
    {
        $this->BestOfferList = $bestOfferList;
        return $this;
    }
    /**
     * Get WonList value
     * @return \StructType\PaginatedOrderTransactionArrayType|null
     */
    public function getWonList()
    {
        return $this->WonList;
    }
    /**
     * Set WonList value
     * @param \StructType\PaginatedOrderTransactionArrayType $wonList
     * @return \StructType\GetMyeBayBuyingResponseType
     */
    public function setWonList(\StructType\PaginatedOrderTransactionArrayType $wonList = null)
    {
        $this->WonList = $wonList;
        return $this;
    }
    /**
     * Get LostList value
     * @return \StructType\PaginatedItemArrayType|null
     */
    public function getLostList()
    {
        return $this->LostList;
    }
    /**
     * Set LostList value
     * @param \StructType\PaginatedItemArrayType $lostList
     * @return \StructType\GetMyeBayBuyingResponseType
     */
    public function setLostList(\StructType\PaginatedItemArrayType $lostList = null)
    {
        $this->LostList = $lostList;
        return $this;
    }
    /**
     * Get FavoriteSearches value
     * @return \StructType\MyeBayFavoriteSearchListType|null
     */
    public function getFavoriteSearches()
    {
        return $this->FavoriteSearches;
    }
    /**
     * Set FavoriteSearches value
     * @param \StructType\MyeBayFavoriteSearchListType $favoriteSearches
     * @return \StructType\GetMyeBayBuyingResponseType
     */
    public function setFavoriteSearches(\StructType\MyeBayFavoriteSearchListType $favoriteSearches = null)
    {
        $this->FavoriteSearches = $favoriteSearches;
        return $this;
    }
    /**
     * Get FavoriteSellers value
     * @return \StructType\MyeBayFavoriteSellerListType|null
     */
    public function getFavoriteSellers()
    {
        return $this->FavoriteSellers;
    }
    /**
     * Set FavoriteSellers value
     * @param \StructType\MyeBayFavoriteSellerListType $favoriteSellers
     * @return \StructType\GetMyeBayBuyingResponseType
     */
    public function setFavoriteSellers(\StructType\MyeBayFavoriteSellerListType $favoriteSellers = null)
    {
        $this->FavoriteSellers = $favoriteSellers;
        return $this;
    }
    /**
     * Get SecondChanceOffer value
     * @return \StructType\ItemType[]|null
     */
    public function getSecondChanceOffer()
    {
        return $this->SecondChanceOffer;
    }
    /**
     * Set SecondChanceOffer value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemType[] $secondChanceOffer
     * @return \StructType\GetMyeBayBuyingResponseType
     */
    public function setSecondChanceOffer(array $secondChanceOffer = array())
    {
        foreach ($secondChanceOffer as $getMyeBayBuyingResponseTypeSecondChanceOfferItem) {
            // validation for constraint: itemType
            if (!$getMyeBayBuyingResponseTypeSecondChanceOfferItem instanceof \StructType\ItemType) {
                throw new \InvalidArgumentException(sprintf('The SecondChanceOffer property can only contain items of \StructType\ItemType, "%s" given', is_object($getMyeBayBuyingResponseTypeSecondChanceOfferItem) ? get_class($getMyeBayBuyingResponseTypeSecondChanceOfferItem) : gettype($getMyeBayBuyingResponseTypeSecondChanceOfferItem)), __LINE__);
            }
        }
        $this->SecondChanceOffer = $secondChanceOffer;
        return $this;
    }
    /**
     * Add item to SecondChanceOffer value
     * @throws \InvalidArgumentException
     * @param \StructType\ItemType $item
     * @return \StructType\GetMyeBayBuyingResponseType
     */
    public function addToSecondChanceOffer(\StructType\ItemType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ItemType) {
            throw new \InvalidArgumentException(sprintf('The SecondChanceOffer property can only contain items of \StructType\ItemType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->SecondChanceOffer[] = $item;
        return $this;
    }
    /**
     * Get BidAssistantList value
     * @return \ArrayType\BidGroupArrayType|null
     */
    public function getBidAssistantList()
    {
        return $this->BidAssistantList;
    }
    /**
     * Set BidAssistantList value
     * @param \ArrayType\BidGroupArrayType $bidAssistantList
     * @return \StructType\GetMyeBayBuyingResponseType
     */
    public function setBidAssistantList(\ArrayType\BidGroupArrayType $bidAssistantList = null)
    {
        $this->BidAssistantList = $bidAssistantList;
        return $this;
    }
    /**
     * Get DeletedFromWonList value
     * @return \StructType\PaginatedOrderTransactionArrayType|null
     */
    public function getDeletedFromWonList()
    {
        return $this->DeletedFromWonList;
    }
    /**
     * Set DeletedFromWonList value
     * @param \StructType\PaginatedOrderTransactionArrayType $deletedFromWonList
     * @return \StructType\GetMyeBayBuyingResponseType
     */
    public function setDeletedFromWonList(\StructType\PaginatedOrderTransactionArrayType $deletedFromWonList = null)
    {
        $this->DeletedFromWonList = $deletedFromWonList;
        return $this;
    }
    /**
     * Get DeletedFromLostList value
     * @return \StructType\PaginatedItemArrayType|null
     */
    public function getDeletedFromLostList()
    {
        return $this->DeletedFromLostList;
    }
    /**
     * Set DeletedFromLostList value
     * @param \StructType\PaginatedItemArrayType $deletedFromLostList
     * @return \StructType\GetMyeBayBuyingResponseType
     */
    public function setDeletedFromLostList(\StructType\PaginatedItemArrayType $deletedFromLostList = null)
    {
        $this->DeletedFromLostList = $deletedFromLostList;
        return $this;
    }
    /**
     * Get UserDefinedList value
     * @return \StructType\UserDefinedListType[]|null
     */
    public function getUserDefinedList()
    {
        return $this->UserDefinedList;
    }
    /**
     * Set UserDefinedList value
     * @throws \InvalidArgumentException
     * @param \StructType\UserDefinedListType[] $userDefinedList
     * @return \StructType\GetMyeBayBuyingResponseType
     */
    public function setUserDefinedList(array $userDefinedList = array())
    {
        foreach ($userDefinedList as $getMyeBayBuyingResponseTypeUserDefinedListItem) {
            // validation for constraint: itemType
            if (!$getMyeBayBuyingResponseTypeUserDefinedListItem instanceof \StructType\UserDefinedListType) {
                throw new \InvalidArgumentException(sprintf('The UserDefinedList property can only contain items of \StructType\UserDefinedListType, "%s" given', is_object($getMyeBayBuyingResponseTypeUserDefinedListItem) ? get_class($getMyeBayBuyingResponseTypeUserDefinedListItem) : gettype($getMyeBayBuyingResponseTypeUserDefinedListItem)), __LINE__);
            }
        }
        $this->UserDefinedList = $userDefinedList;
        return $this;
    }
    /**
     * Add item to UserDefinedList value
     * @throws \InvalidArgumentException
     * @param \StructType\UserDefinedListType $item
     * @return \StructType\GetMyeBayBuyingResponseType
     */
    public function addToUserDefinedList(\StructType\UserDefinedListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UserDefinedListType) {
            throw new \InvalidArgumentException(sprintf('The UserDefinedList property can only contain items of \StructType\UserDefinedListType, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UserDefinedList[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetMyeBayBuyingResponseType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
