<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EndOfAuctionEmailPreferencesType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Contains the seller's preferences for the email sent to the buyer after the creation of the order line item.
 * @subpackage Structs
 */
class EndOfAuctionEmailPreferencesType extends AbstractStructBase
{
    /**
     * The TemplateText
     * Meta informations extracted from the WSDL
     * - documentation: The text of the custom message for the email.
     * - minOccurs: 0
     * @var string
     */
    public $TemplateText;
    /**
     * The LogoURL
     * Meta informations extracted from the WSDL
     * - documentation: The URL of the logo to include in the customized email.
     * - minOccurs: 0
     * @var string
     */
    public $LogoURL;
    /**
     * The LogoType
     * Meta informations extracted from the WSDL
     * - documentation: The type of logo to include in the customized email.
     * - minOccurs: 0
     * @var string
     */
    public $LogoType;
    /**
     * The EmailCustomized
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether or not the seller wishes to send a customized email to winning buyers.
     * - minOccurs: 0
     * @var bool
     */
    public $EmailCustomized;
    /**
     * The TextCustomized
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether or not the text of the customized message will be customized.
     * - minOccurs: 0
     * @var bool
     */
    public $TextCustomized;
    /**
     * The LogoCustomized
     * Meta informations extracted from the WSDL
     * - documentation: Indicates whether or not the seller wishes to include a logo in the customized email.
     * - minOccurs: 0
     * @var bool
     */
    public $LogoCustomized;
    /**
     * The CopyEmail
     * Meta informations extracted from the WSDL
     * - documentation: This field is deprecated.
     * - minOccurs: 0
     * @var bool
     */
    public $CopyEmail;
    /**
     * The any
     * @var \DOMDocument
     */
    public $any;
    /**
     * Constructor method for EndOfAuctionEmailPreferencesType
     * @uses EndOfAuctionEmailPreferencesType::setTemplateText()
     * @uses EndOfAuctionEmailPreferencesType::setLogoURL()
     * @uses EndOfAuctionEmailPreferencesType::setLogoType()
     * @uses EndOfAuctionEmailPreferencesType::setEmailCustomized()
     * @uses EndOfAuctionEmailPreferencesType::setTextCustomized()
     * @uses EndOfAuctionEmailPreferencesType::setLogoCustomized()
     * @uses EndOfAuctionEmailPreferencesType::setCopyEmail()
     * @uses EndOfAuctionEmailPreferencesType::setAny()
     * @param string $templateText
     * @param string $logoURL
     * @param string $logoType
     * @param bool $emailCustomized
     * @param bool $textCustomized
     * @param bool $logoCustomized
     * @param bool $copyEmail
     * @param \DOMDocument $any
     */
    public function __construct($templateText = null, $logoURL = null, $logoType = null, $emailCustomized = null, $textCustomized = null, $logoCustomized = null, $copyEmail = null, \DOMDocument $any = null)
    {
        $this
            ->setTemplateText($templateText)
            ->setLogoURL($logoURL)
            ->setLogoType($logoType)
            ->setEmailCustomized($emailCustomized)
            ->setTextCustomized($textCustomized)
            ->setLogoCustomized($logoCustomized)
            ->setCopyEmail($copyEmail)
            ->setAny($any);
    }
    /**
     * Get TemplateText value
     * @return string|null
     */
    public function getTemplateText()
    {
        return $this->TemplateText;
    }
    /**
     * Set TemplateText value
     * @param string $templateText
     * @return \StructType\EndOfAuctionEmailPreferencesType
     */
    public function setTemplateText($templateText = null)
    {
        // validation for constraint: string
        if (!is_null($templateText) && !is_string($templateText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($templateText)), __LINE__);
        }
        $this->TemplateText = $templateText;
        return $this;
    }
    /**
     * Get LogoURL value
     * @return string|null
     */
    public function getLogoURL()
    {
        return $this->LogoURL;
    }
    /**
     * Set LogoURL value
     * @param string $logoURL
     * @return \StructType\EndOfAuctionEmailPreferencesType
     */
    public function setLogoURL($logoURL = null)
    {
        // validation for constraint: string
        if (!is_null($logoURL) && !is_string($logoURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($logoURL)), __LINE__);
        }
        $this->LogoURL = $logoURL;
        return $this;
    }
    /**
     * Get LogoType value
     * @return string|null
     */
    public function getLogoType()
    {
        return $this->LogoType;
    }
    /**
     * Set LogoType value
     * @uses \EnumType\EndOfAuctionLogoTypeCodeType::valueIsValid()
     * @uses \EnumType\EndOfAuctionLogoTypeCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $logoType
     * @return \StructType\EndOfAuctionEmailPreferencesType
     */
    public function setLogoType($logoType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EndOfAuctionLogoTypeCodeType::valueIsValid($logoType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $logoType, implode(', ', \EnumType\EndOfAuctionLogoTypeCodeType::getValidValues())), __LINE__);
        }
        $this->LogoType = $logoType;
        return $this;
    }
    /**
     * Get EmailCustomized value
     * @return bool|null
     */
    public function getEmailCustomized()
    {
        return $this->EmailCustomized;
    }
    /**
     * Set EmailCustomized value
     * @param bool $emailCustomized
     * @return \StructType\EndOfAuctionEmailPreferencesType
     */
    public function setEmailCustomized($emailCustomized = null)
    {
        $this->EmailCustomized = $emailCustomized;
        return $this;
    }
    /**
     * Get TextCustomized value
     * @return bool|null
     */
    public function getTextCustomized()
    {
        return $this->TextCustomized;
    }
    /**
     * Set TextCustomized value
     * @param bool $textCustomized
     * @return \StructType\EndOfAuctionEmailPreferencesType
     */
    public function setTextCustomized($textCustomized = null)
    {
        $this->TextCustomized = $textCustomized;
        return $this;
    }
    /**
     * Get LogoCustomized value
     * @return bool|null
     */
    public function getLogoCustomized()
    {
        return $this->LogoCustomized;
    }
    /**
     * Set LogoCustomized value
     * @param bool $logoCustomized
     * @return \StructType\EndOfAuctionEmailPreferencesType
     */
    public function setLogoCustomized($logoCustomized = null)
    {
        $this->LogoCustomized = $logoCustomized;
        return $this;
    }
    /**
     * Get CopyEmail value
     * @return bool|null
     */
    public function getCopyEmail()
    {
        return $this->CopyEmail;
    }
    /**
     * Set CopyEmail value
     * @param bool $copyEmail
     * @return \StructType\EndOfAuctionEmailPreferencesType
     */
    public function setCopyEmail($copyEmail = null)
    {
        $this->CopyEmail = $copyEmail;
        return $this;
    }
    /**
     * Get any value
     * @uses \DOMDocument::loadXML()
     * @uses \DOMDocument::hasChildNodes()
     * @uses \DOMDocument::saveXML()
     * @uses \DOMNode::item()
     * @uses \StructType\EndOfAuctionEmailPreferencesType::setAny()
     * @param bool $asString true: returns XML string, false: returns \DOMDocument
     * @return \DOMDocument|null
     */
    public function getAny($asString = true)
    {
        if (!empty($this->any) && !($this->any instanceof \DOMDocument)) {
            $dom = new \DOMDocument('1.0', 'UTF-8');
            $dom->formatOutput = true;
            if ($dom->loadXML($this->any)) {
                $this->setAny($dom);
            }
            unset($dom);
        }
        return ($asString && ($this->any instanceof \DOMDocument) && $this->any->hasChildNodes()) ? $this->any->saveXML($this->any->childNodes->item(0)) : $this->any;
    }
    /**
     * Set any value
     * @param \DOMDocument $any
     * @return \StructType\EndOfAuctionEmailPreferencesType
     */
    public function setAny(\DOMDocument $any = null)
    {
        $this->any = $any;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EndOfAuctionEmailPreferencesType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
