<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EndFixedPriceItemRequestType StructType
 * Meta informations extracted from the WSDL
 * - documentation: Ends the specified fixed-price listing before the date and time at which it would normally end (per the listing duration).
 * @subpackage Structs
 */
class EndFixedPriceItemRequestType extends AbstractRequestType
{
    /**
     * The ItemID
     * Meta informations extracted from the WSDL
     * - documentation: Unique item ID that identifies the item listing that you want to end. <br><br> In the EndFixedPriceItem request, either ItemID or SKU is required. If both are passed in and they don't refer to the same listing, eBay ignores SKU and
     * considers only the ItemID. | Type that represents the unique identifier for a single item listing.
     * - minOccurs: 0
     * @var string
     */
    public $ItemID;
    /**
     * The EndingReason
     * Meta informations extracted from the WSDL
     * - documentation: Indicates the seller's reason for ending the listing early. This field is required if the seller is ending the item early and the item did not successfully sell.
     * - minOccurs: 0
     * @var string
     */
    public $EndingReason;
    /**
     * The SKU
     * Meta informations extracted from the WSDL
     * - documentation: The unique SKU of the item being ended. A SKU (stock keeping unit) is an identifier defined by a seller. SKU can only be used to end an item if you listed the item by using AddFixedPriceItem or RelistFixedPriceItem, and you set
     * Item.InventoryTrackingMethod to SKU at the time the item was listed. (These criteria are necessary to uniquely identify the listing by a SKU.) <br><br> In the EndFixedPriceItem request, either ItemID or SKU is required. If both are passed in and they
     * don't refer to the same listing, eBay ignores SKU and considers only the ItemID. <br><br> To remove a SKU when you revise or relist an item, use DeletedField in the revision or relist call. | Primitive type that represents a stock-keeping unit (SKU).
     * The usage of this string may vary in different contexts. For usage information and rules, see the fields that reference this type.
     * - minOccurs: 0
     * @var string
     */
    public $SKU;
    /**
     * Constructor method for EndFixedPriceItemRequestType
     * @uses EndFixedPriceItemRequestType::setItemID()
     * @uses EndFixedPriceItemRequestType::setEndingReason()
     * @uses EndFixedPriceItemRequestType::setSKU()
     * @param string $itemID
     * @param string $endingReason
     * @param string $sKU
     */
    public function __construct($itemID = null, $endingReason = null, $sKU = null)
    {
        $this
            ->setItemID($itemID)
            ->setEndingReason($endingReason)
            ->setSKU($sKU);
    }
    /**
     * Get ItemID value
     * @return string|null
     */
    public function getItemID()
    {
        return $this->ItemID;
    }
    /**
     * Set ItemID value
     * @param string $itemID
     * @return \StructType\EndFixedPriceItemRequestType
     */
    public function setItemID($itemID = null)
    {
        // validation for constraint: string
        if (!is_null($itemID) && !is_string($itemID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemID)), __LINE__);
        }
        $this->ItemID = $itemID;
        return $this;
    }
    /**
     * Get EndingReason value
     * @return string|null
     */
    public function getEndingReason()
    {
        return $this->EndingReason;
    }
    /**
     * Set EndingReason value
     * @uses \EnumType\EndReasonCodeType::valueIsValid()
     * @uses \EnumType\EndReasonCodeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $endingReason
     * @return \StructType\EndFixedPriceItemRequestType
     */
    public function setEndingReason($endingReason = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EndReasonCodeType::valueIsValid($endingReason)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $endingReason, implode(', ', \EnumType\EndReasonCodeType::getValidValues())), __LINE__);
        }
        $this->EndingReason = $endingReason;
        return $this;
    }
    /**
     * Get SKU value
     * @return string|null
     */
    public function getSKU()
    {
        return $this->SKU;
    }
    /**
     * Set SKU value
     * @param string $sKU
     * @return \StructType\EndFixedPriceItemRequestType
     */
    public function setSKU($sKU = null)
    {
        // validation for constraint: string
        if (!is_null($sKU) && !is_string($sKU)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sKU)), __LINE__);
        }
        $this->SKU = $sKU;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EndFixedPriceItemRequestType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
