<?php

namespace EnumType;

/**
 * This class stands for WarrantyOfferedCodeType EnumType
 * Meta informations extracted from the WSDL
 * - documentation: This enumerated type contains the value that should be passed into the <b>ReturnPolicy.WarrantyOfferedOption</b> field of an add/revise/relist API call if the seller wishes to offer a warranty to the buyer. The seller should call
 * <b>GeteBayDetails</b> to get this enumeration value that is returned in the <b>ReturnPolicyDetails.WarrantyOffered</b> container(s) in the response. <br><br> The <b>ReturnPolicyDetails</b> container will be returned if a <b>DetailName</b> field is
 * set to <code>ReturnPolicyDetails</code> in the request, or if no <b>DetailName</b> field is set in the request.
 * @subpackage Enumerations
 */
class WarrantyOfferedCodeType
{
    /**
     * Constant for value 'WarrantyOffered'
     * @return string 'WarrantyOffered'
     */
    const VALUE_WARRANTY_OFFERED = 'WarrantyOffered';
    /**
     * Constant for value 'CustomCode'
     * @return string 'CustomCode'
     */
    const VALUE_CUSTOM_CODE = 'CustomCode';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_WARRANTY_OFFERED
     * @uses self::VALUE_CUSTOM_CODE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_WARRANTY_OFFERED,
            self::VALUE_CUSTOM_CODE,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
