<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for listaRiscosWsVo StructType
 * @subpackage Structs
 */
class ListaRiscosWsVo extends AbstractStructBase
{
    /**
     * The listaCodigoRiscos
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $listaCodigoRiscos;
    /**
     * The tipoBuscaRiscos
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipoBuscaRiscos;
    /**
     * Constructor method for listaRiscosWsVo
     * @uses ListaRiscosWsVo::setListaCodigoRiscos()
     * @uses ListaRiscosWsVo::setTipoBuscaRiscos()
     * @param string[] $listaCodigoRiscos
     * @param string $tipoBuscaRiscos
     */
    public function __construct(array $listaCodigoRiscos = array(), $tipoBuscaRiscos = null)
    {
        $this
            ->setListaCodigoRiscos($listaCodigoRiscos)
            ->setTipoBuscaRiscos($tipoBuscaRiscos);
    }
    /**
     * Get listaCodigoRiscos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getListaCodigoRiscos()
    {
        return isset($this->listaCodigoRiscos) ? $this->listaCodigoRiscos : null;
    }
    /**
     * This method is responsible for validating the values passed to the setListaCodigoRiscos method
     * This method is willingly generated in order to preserve the one-line inline validation within the setListaCodigoRiscos method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateListaCodigoRiscosForArrayConstraintsFromSetListaCodigoRiscos(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $listaRiscosWsVoListaCodigoRiscosItem) {
            // validation for constraint: itemType
            if (!is_string($listaRiscosWsVoListaCodigoRiscosItem)) {
                $invalidValues[] = is_object($listaRiscosWsVoListaCodigoRiscosItem) ? get_class($listaRiscosWsVoListaCodigoRiscosItem) : sprintf('%s(%s)', gettype($listaRiscosWsVoListaCodigoRiscosItem), var_export($listaRiscosWsVoListaCodigoRiscosItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The listaCodigoRiscos property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set listaCodigoRiscos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param string[] $listaCodigoRiscos
     * @return \StructType\ListaRiscosWsVo
     */
    public function setListaCodigoRiscos(array $listaCodigoRiscos = array())
    {
        // validation for constraint: array
        if ('' !== ($listaCodigoRiscosArrayErrorMessage = self::validateListaCodigoRiscosForArrayConstraintsFromSetListaCodigoRiscos($listaCodigoRiscos))) {
            throw new \InvalidArgumentException($listaCodigoRiscosArrayErrorMessage, __LINE__);
        }
        if (is_null($listaCodigoRiscos) || (is_array($listaCodigoRiscos) && empty($listaCodigoRiscos))) {
            unset($this->listaCodigoRiscos);
        } else {
            $this->listaCodigoRiscos = $listaCodigoRiscos;
        }
        return $this;
    }
    /**
     * Add item to listaCodigoRiscos value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\ListaRiscosWsVo
     */
    public function addToListaCodigoRiscos($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The listaCodigoRiscos property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->listaCodigoRiscos[] = $item;
        return $this;
    }
    /**
     * Get tipoBuscaRiscos value
     * @return string|null
     */
    public function getTipoBuscaRiscos()
    {
        return $this->tipoBuscaRiscos;
    }
    /**
     * Set tipoBuscaRiscos value
     * @uses \EnumType\TipoBuscaRiscos::valueIsValid()
     * @uses \EnumType\TipoBuscaRiscos::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoBuscaRiscos
     * @return \StructType\ListaRiscosWsVo
     */
    public function setTipoBuscaRiscos($tipoBuscaRiscos = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoBuscaRiscos::valueIsValid($tipoBuscaRiscos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipoBuscaRiscos', is_array($tipoBuscaRiscos) ? implode(', ', $tipoBuscaRiscos) : var_export($tipoBuscaRiscos, true), implode(', ', \EnumType\TipoBuscaRiscos::getValidValues())), __LINE__);
        }
        $this->tipoBuscaRiscos = $tipoBuscaRiscos;
        return $this;
    }
}
