<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IncluirPedidoExameWsVo StructType
 * @subpackage Structs
 */
class IncluirPedidoExameWsVo extends AbstractStructBase
{
    /**
     * The identificacao
     * @var \StructType\IdentificacaoUsuarioWsVo
     */
    public $identificacao;
    /**
     * The tipoBuscaEmpresa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipoBuscaEmpresa;
    /**
     * The codigoEmpresa
     * @var string
     */
    public $codigoEmpresa;
    /**
     * The tipoBuscaFuncionario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipoBuscaFuncionario;
    /**
     * The codigoFuncionario
     * @var string
     */
    public $codigoFuncionario;
    /**
     * The dataFicha
     * @var string
     */
    public $dataFicha;
    /**
     * The tipoExame
     * @var string
     */
    public $tipoExame;
    /**
     * The exames
     * @var \StructType\PedidoExamesListaWsVo
     */
    public $exames;
    /**
     * The tipoBuscaMedico
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipoBuscaMedico;
    /**
     * The codigoMedico
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codigoMedico;
    /**
     * The campoString01
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $campoString01;
    /**
     * Constructor method for IncluirPedidoExameWsVo
     * @uses IncluirPedidoExameWsVo::setIdentificacao()
     * @uses IncluirPedidoExameWsVo::setTipoBuscaEmpresa()
     * @uses IncluirPedidoExameWsVo::setCodigoEmpresa()
     * @uses IncluirPedidoExameWsVo::setTipoBuscaFuncionario()
     * @uses IncluirPedidoExameWsVo::setCodigoFuncionario()
     * @uses IncluirPedidoExameWsVo::setDataFicha()
     * @uses IncluirPedidoExameWsVo::setTipoExame()
     * @uses IncluirPedidoExameWsVo::setExames()
     * @uses IncluirPedidoExameWsVo::setTipoBuscaMedico()
     * @uses IncluirPedidoExameWsVo::setCodigoMedico()
     * @uses IncluirPedidoExameWsVo::setCampoString01()
     * @param \StructType\IdentificacaoUsuarioWsVo $identificacao
     * @param string $tipoBuscaEmpresa
     * @param string $codigoEmpresa
     * @param string $tipoBuscaFuncionario
     * @param string $codigoFuncionario
     * @param string $dataFicha
     * @param string $tipoExame
     * @param \StructType\PedidoExamesListaWsVo $exames
     * @param string $tipoBuscaMedico
     * @param string $codigoMedico
     * @param string $campoString01
     */
    public function __construct(\StructType\IdentificacaoUsuarioWsVo $identificacao = null, $tipoBuscaEmpresa = null, $codigoEmpresa = null, $tipoBuscaFuncionario = null, $codigoFuncionario = null, $dataFicha = null, $tipoExame = null, \StructType\PedidoExamesListaWsVo $exames = null, $tipoBuscaMedico = null, $codigoMedico = null, $campoString01 = null)
    {
        $this
            ->setIdentificacao($identificacao)
            ->setTipoBuscaEmpresa($tipoBuscaEmpresa)
            ->setCodigoEmpresa($codigoEmpresa)
            ->setTipoBuscaFuncionario($tipoBuscaFuncionario)
            ->setCodigoFuncionario($codigoFuncionario)
            ->setDataFicha($dataFicha)
            ->setTipoExame($tipoExame)
            ->setExames($exames)
            ->setTipoBuscaMedico($tipoBuscaMedico)
            ->setCodigoMedico($codigoMedico)
            ->setCampoString01($campoString01);
    }
    /**
     * Get identificacao value
     * @return \StructType\IdentificacaoUsuarioWsVo|null
     */
    public function getIdentificacao()
    {
        return $this->identificacao;
    }
    /**
     * Set identificacao value
     * @param \StructType\IdentificacaoUsuarioWsVo $identificacao
     * @return \StructType\IncluirPedidoExameWsVo
     */
    public function setIdentificacao(\StructType\IdentificacaoUsuarioWsVo $identificacao = null)
    {
        $this->identificacao = $identificacao;
        return $this;
    }
    /**
     * Get tipoBuscaEmpresa value
     * @return string|null
     */
    public function getTipoBuscaEmpresa()
    {
        return $this->tipoBuscaEmpresa;
    }
    /**
     * Set tipoBuscaEmpresa value
     * @uses \EnumType\TipoBuscaEmpresaEnum::valueIsValid()
     * @uses \EnumType\TipoBuscaEmpresaEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoBuscaEmpresa
     * @return \StructType\IncluirPedidoExameWsVo
     */
    public function setTipoBuscaEmpresa($tipoBuscaEmpresa = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoBuscaEmpresaEnum::valueIsValid($tipoBuscaEmpresa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipoBuscaEmpresaEnum', is_array($tipoBuscaEmpresa) ? implode(', ', $tipoBuscaEmpresa) : var_export($tipoBuscaEmpresa, true), implode(', ', \EnumType\TipoBuscaEmpresaEnum::getValidValues())), __LINE__);
        }
        $this->tipoBuscaEmpresa = $tipoBuscaEmpresa;
        return $this;
    }
    /**
     * Get codigoEmpresa value
     * @return string|null
     */
    public function getCodigoEmpresa()
    {
        return $this->codigoEmpresa;
    }
    /**
     * Set codigoEmpresa value
     * @param string $codigoEmpresa
     * @return \StructType\IncluirPedidoExameWsVo
     */
    public function setCodigoEmpresa($codigoEmpresa = null)
    {
        // validation for constraint: string
        if (!is_null($codigoEmpresa) && !is_string($codigoEmpresa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoEmpresa, true), gettype($codigoEmpresa)), __LINE__);
        }
        $this->codigoEmpresa = $codigoEmpresa;
        return $this;
    }
    /**
     * Get tipoBuscaFuncionario value
     * @return string|null
     */
    public function getTipoBuscaFuncionario()
    {
        return $this->tipoBuscaFuncionario;
    }
    /**
     * Set tipoBuscaFuncionario value
     * @uses \EnumType\BuscaFuncionario::valueIsValid()
     * @uses \EnumType\BuscaFuncionario::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoBuscaFuncionario
     * @return \StructType\IncluirPedidoExameWsVo
     */
    public function setTipoBuscaFuncionario($tipoBuscaFuncionario = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BuscaFuncionario::valueIsValid($tipoBuscaFuncionario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\BuscaFuncionario', is_array($tipoBuscaFuncionario) ? implode(', ', $tipoBuscaFuncionario) : var_export($tipoBuscaFuncionario, true), implode(', ', \EnumType\BuscaFuncionario::getValidValues())), __LINE__);
        }
        $this->tipoBuscaFuncionario = $tipoBuscaFuncionario;
        return $this;
    }
    /**
     * Get codigoFuncionario value
     * @return string|null
     */
    public function getCodigoFuncionario()
    {
        return $this->codigoFuncionario;
    }
    /**
     * Set codigoFuncionario value
     * @param string $codigoFuncionario
     * @return \StructType\IncluirPedidoExameWsVo
     */
    public function setCodigoFuncionario($codigoFuncionario = null)
    {
        // validation for constraint: string
        if (!is_null($codigoFuncionario) && !is_string($codigoFuncionario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoFuncionario, true), gettype($codigoFuncionario)), __LINE__);
        }
        $this->codigoFuncionario = $codigoFuncionario;
        return $this;
    }
    /**
     * Get dataFicha value
     * @return string|null
     */
    public function getDataFicha()
    {
        return $this->dataFicha;
    }
    /**
     * Set dataFicha value
     * @param string $dataFicha
     * @return \StructType\IncluirPedidoExameWsVo
     */
    public function setDataFicha($dataFicha = null)
    {
        // validation for constraint: string
        if (!is_null($dataFicha) && !is_string($dataFicha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataFicha, true), gettype($dataFicha)), __LINE__);
        }
        $this->dataFicha = $dataFicha;
        return $this;
    }
    /**
     * Get tipoExame value
     * @return string|null
     */
    public function getTipoExame()
    {
        return $this->tipoExame;
    }
    /**
     * Set tipoExame value
     * @param string $tipoExame
     * @return \StructType\IncluirPedidoExameWsVo
     */
    public function setTipoExame($tipoExame = null)
    {
        // validation for constraint: string
        if (!is_null($tipoExame) && !is_string($tipoExame)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tipoExame, true), gettype($tipoExame)), __LINE__);
        }
        $this->tipoExame = $tipoExame;
        return $this;
    }
    /**
     * Get exames value
     * @return \StructType\PedidoExamesListaWsVo|null
     */
    public function getExames()
    {
        return $this->exames;
    }
    /**
     * Set exames value
     * @param \StructType\PedidoExamesListaWsVo $exames
     * @return \StructType\IncluirPedidoExameWsVo
     */
    public function setExames(\StructType\PedidoExamesListaWsVo $exames = null)
    {
        $this->exames = $exames;
        return $this;
    }
    /**
     * Get tipoBuscaMedico value
     * @return string|null
     */
    public function getTipoBuscaMedico()
    {
        return $this->tipoBuscaMedico;
    }
    /**
     * Set tipoBuscaMedico value
     * @uses \EnumType\TipoBuscaEnum::valueIsValid()
     * @uses \EnumType\TipoBuscaEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoBuscaMedico
     * @return \StructType\IncluirPedidoExameWsVo
     */
    public function setTipoBuscaMedico($tipoBuscaMedico = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoBuscaEnum::valueIsValid($tipoBuscaMedico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipoBuscaEnum', is_array($tipoBuscaMedico) ? implode(', ', $tipoBuscaMedico) : var_export($tipoBuscaMedico, true), implode(', ', \EnumType\TipoBuscaEnum::getValidValues())), __LINE__);
        }
        $this->tipoBuscaMedico = $tipoBuscaMedico;
        return $this;
    }
    /**
     * Get codigoMedico value
     * @return string|null
     */
    public function getCodigoMedico()
    {
        return $this->codigoMedico;
    }
    /**
     * Set codigoMedico value
     * @param string $codigoMedico
     * @return \StructType\IncluirPedidoExameWsVo
     */
    public function setCodigoMedico($codigoMedico = null)
    {
        // validation for constraint: string
        if (!is_null($codigoMedico) && !is_string($codigoMedico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoMedico, true), gettype($codigoMedico)), __LINE__);
        }
        $this->codigoMedico = $codigoMedico;
        return $this;
    }
    /**
     * Get campoString01 value
     * @return string|null
     */
    public function getCampoString01()
    {
        return $this->campoString01;
    }
    /**
     * Set campoString01 value
     * @param string $campoString01
     * @return \StructType\IncluirPedidoExameWsVo
     */
    public function setCampoString01($campoString01 = null)
    {
        // validation for constraint: string
        if (!is_null($campoString01) && !is_string($campoString01)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campoString01, true), gettype($campoString01)), __LINE__);
        }
        $this->campoString01 = $campoString01;
        return $this;
    }
}
