<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for exame StructType
 * @subpackage Structs
 */
class Exame extends AbstractStructBase
{
    /**
     * The codigo
     * @var string
     */
    public $codigo;
    /**
     * The tipoBusca
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipoBusca;
    /**
     * The codigoPrestador
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codigoPrestador;
    /**
     * The tipoBuscaPrestador
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipoBuscaPrestador;
    /**
     * Constructor method for exame
     * @uses Exame::setCodigo()
     * @uses Exame::setTipoBusca()
     * @uses Exame::setCodigoPrestador()
     * @uses Exame::setTipoBuscaPrestador()
     * @param string $codigo
     * @param string $tipoBusca
     * @param string $codigoPrestador
     * @param string $tipoBuscaPrestador
     */
    public function __construct($codigo = null, $tipoBusca = null, $codigoPrestador = null, $tipoBuscaPrestador = null)
    {
        $this
            ->setCodigo($codigo)
            ->setTipoBusca($tipoBusca)
            ->setCodigoPrestador($codigoPrestador)
            ->setTipoBuscaPrestador($tipoBuscaPrestador);
    }
    /**
     * Get codigo value
     * @return string|null
     */
    public function getCodigo()
    {
        return $this->codigo;
    }
    /**
     * Set codigo value
     * @param string $codigo
     * @return \StructType\Exame
     */
    public function setCodigo($codigo = null)
    {
        // validation for constraint: string
        if (!is_null($codigo) && !is_string($codigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigo, true), gettype($codigo)), __LINE__);
        }
        $this->codigo = $codigo;
        return $this;
    }
    /**
     * Get tipoBusca value
     * @return string|null
     */
    public function getTipoBusca()
    {
        return $this->tipoBusca;
    }
    /**
     * Set tipoBusca value
     * @uses \EnumType\TipoBuscaEnum::valueIsValid()
     * @uses \EnumType\TipoBuscaEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoBusca
     * @return \StructType\Exame
     */
    public function setTipoBusca($tipoBusca = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoBuscaEnum::valueIsValid($tipoBusca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipoBuscaEnum', is_array($tipoBusca) ? implode(', ', $tipoBusca) : var_export($tipoBusca, true), implode(', ', \EnumType\TipoBuscaEnum::getValidValues())), __LINE__);
        }
        $this->tipoBusca = $tipoBusca;
        return $this;
    }
    /**
     * Get codigoPrestador value
     * @return string|null
     */
    public function getCodigoPrestador()
    {
        return $this->codigoPrestador;
    }
    /**
     * Set codigoPrestador value
     * @param string $codigoPrestador
     * @return \StructType\Exame
     */
    public function setCodigoPrestador($codigoPrestador = null)
    {
        // validation for constraint: string
        if (!is_null($codigoPrestador) && !is_string($codigoPrestador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoPrestador, true), gettype($codigoPrestador)), __LINE__);
        }
        $this->codigoPrestador = $codigoPrestador;
        return $this;
    }
    /**
     * Get tipoBuscaPrestador value
     * @return string|null
     */
    public function getTipoBuscaPrestador()
    {
        return $this->tipoBuscaPrestador;
    }
    /**
     * Set tipoBuscaPrestador value
     * @uses \EnumType\TipoBuscaEnum::valueIsValid()
     * @uses \EnumType\TipoBuscaEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoBuscaPrestador
     * @return \StructType\Exame
     */
    public function setTipoBuscaPrestador($tipoBuscaPrestador = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoBuscaEnum::valueIsValid($tipoBuscaPrestador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipoBuscaEnum', is_array($tipoBuscaPrestador) ? implode(', ', $tipoBuscaPrestador) : var_export($tipoBuscaPrestador, true), implode(', ', \EnumType\TipoBuscaEnum::getValidValues())), __LINE__);
        }
        $this->tipoBuscaPrestador = $tipoBuscaPrestador;
        return $this;
    }
}
