<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Incluir ServiceType
 * @subpackage Services
 */
class Incluir extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named incluirPedidoExame
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\IncluirPedidoExame $parameters
     * @return \StructType\IncluirPedidoExameResponse|bool
     */
    public function incluirPedidoExame(\StructType\IncluirPedidoExame $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->incluirPedidoExame($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\IncluirPedidoExameResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
