<?php

namespace EnumType;

use \WsdlToPhp\PackageBase\AbstractStructEnumBase;

/**
 * This class stands for tipoMascaramento EnumType
 * @subpackage Enumerations
 */
class TipoMascaramento extends AbstractStructEnumBase
{
    /**
     * Constant for value 'NARROW_BAND'
     * @return string 'NARROW_BAND'
     */
    const VALUE_NARROW_BAND = 'NARROW_BAND';
    /**
     * Constant for value 'PINK_NOISE'
     * @return string 'PINK_NOISE'
     */
    const VALUE_PINK_NOISE = 'PINK_NOISE';
    /**
     * Constant for value 'SPEACH_NOISE'
     * @return string 'SPEACH_NOISE'
     */
    const VALUE_SPEACH_NOISE = 'SPEACH_NOISE';
    /**
     * Constant for value 'WHITE_NOISE'
     * @return string 'WHITE_NOISE'
     */
    const VALUE_WHITE_NOISE = 'WHITE_NOISE';
    /**
     * Return allowed values
     * @uses self::VALUE_NARROW_BAND
     * @uses self::VALUE_PINK_NOISE
     * @uses self::VALUE_SPEACH_NOISE
     * @uses self::VALUE_WHITE_NOISE
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_NARROW_BAND,
            self::VALUE_PINK_NOISE,
            self::VALUE_SPEACH_NOISE,
            self::VALUE_WHITE_NOISE,
        );
    }
}
