<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the first needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientBase class (each generated ServiceType class extends this class)
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://ws1.soc.com.br/WSSoc/services/ResultadoExamesWs?wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc...
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://ws1.soc.com.br/WSSoc/services/ResultadoExamesWs?wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Respostas ServiceType
 */
$respostas = new \ServiceType\Respostas($options);
/**
 * Sample call for respostasPersonalizacao operation/method
 */
if ($respostas->respostasPersonalizacao(new \StructType\RespostasPersonalizacao()) !== false) {
    print_r($respostas->getResult());
} else {
    print_r($respostas->getLastError());
}
/**
 * Samples for Inclui ServiceType
 */
$inclui = new \ServiceType\Inclui($options);
/**
 * Sample call for incluiDadosAso operation/method
 */
if ($inclui->incluiDadosAso(new \StructType\IncluiDadosAso()) !== false) {
    print_r($inclui->getResult());
} else {
    print_r($inclui->getLastError());
}
/**
 * Samples for Resultado ServiceType
 */
$resultado = new \ServiceType\Resultado($options);
/**
 * Sample call for resultadoExamesPorFuncionarioFicha operation/method
 */
if ($resultado->resultadoExamesPorFuncionarioFicha(new \StructType\ResultadoExamesPorFuncionarioFicha()) !== false) {
    print_r($resultado->getResult());
} else {
    print_r($resultado->getLastError());
}
/**
 * Sample call for resultadoExamesPorCodigoSequencial operation/method
 */
if ($resultado->resultadoExamesPorCodigoSequencial(new \StructType\ResultadoExamesPorCodigoSequencial()) !== false) {
    print_r($resultado->getResult());
} else {
    print_r($resultado->getLastError());
}
/**
 * Samples for Excluir ServiceType
 */
$excluir = new \ServiceType\Excluir($options);
/**
 * Sample call for excluirPedidoExamePorFuncionarioFicha operation/method
 */
if ($excluir->excluirPedidoExamePorFuncionarioFicha(new \StructType\ExcluirPedidoExamePorFuncionarioFicha()) !== false) {
    print_r($excluir->getResult());
} else {
    print_r($excluir->getLastError());
}
/**
 * Samples for Incluir ServiceType
 */
$incluir = new \ServiceType\Incluir($options);
/**
 * Sample call for incluirPedidoExame operation/method
 */
if ($incluir->incluirPedidoExame(new \StructType\IncluirPedidoExame()) !== false) {
    print_r($incluir->getResult());
} else {
    print_r($incluir->getLastError());
}
