<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersonalizacaoRetornoWsVo StructType
 * @subpackage Structs
 */
class PersonalizacaoRetornoWsVo extends AbstractStructBase
{
    /**
     * The descricaoErroAviso
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $descricaoErroAviso;
    /**
     * The erro
     * @var bool
     */
    public $erro;
    /**
     * The respostasList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PersonalizacaoDadosWsVo[]
     */
    public $respostasList;
    /**
     * Constructor method for PersonalizacaoRetornoWsVo
     * @uses PersonalizacaoRetornoWsVo::setDescricaoErroAviso()
     * @uses PersonalizacaoRetornoWsVo::setErro()
     * @uses PersonalizacaoRetornoWsVo::setRespostasList()
     * @param string $descricaoErroAviso
     * @param bool $erro
     * @param \StructType\PersonalizacaoDadosWsVo[] $respostasList
     */
    public function __construct($descricaoErroAviso = null, $erro = null, array $respostasList = array())
    {
        $this
            ->setDescricaoErroAviso($descricaoErroAviso)
            ->setErro($erro)
            ->setRespostasList($respostasList);
    }
    /**
     * Get descricaoErroAviso value
     * @return string|null
     */
    public function getDescricaoErroAviso()
    {
        return $this->descricaoErroAviso;
    }
    /**
     * Set descricaoErroAviso value
     * @param string $descricaoErroAviso
     * @return \StructType\PersonalizacaoRetornoWsVo
     */
    public function setDescricaoErroAviso($descricaoErroAviso = null)
    {
        // validation for constraint: string
        if (!is_null($descricaoErroAviso) && !is_string($descricaoErroAviso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descricaoErroAviso, true), gettype($descricaoErroAviso)), __LINE__);
        }
        $this->descricaoErroAviso = $descricaoErroAviso;
        return $this;
    }
    /**
     * Get erro value
     * @return bool|null
     */
    public function getErro()
    {
        return $this->erro;
    }
    /**
     * Set erro value
     * @param bool $erro
     * @return \StructType\PersonalizacaoRetornoWsVo
     */
    public function setErro($erro = null)
    {
        // validation for constraint: boolean
        if (!is_null($erro) && !is_bool($erro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($erro, true), gettype($erro)), __LINE__);
        }
        $this->erro = $erro;
        return $this;
    }
    /**
     * Get respostasList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PersonalizacaoDadosWsVo[]|null
     */
    public function getRespostasList()
    {
        return isset($this->respostasList) ? $this->respostasList : null;
    }
    /**
     * This method is responsible for validating the values passed to the setRespostasList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setRespostasList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateRespostasListForArrayConstraintsFromSetRespostasList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $personalizacaoRetornoWsVoRespostasListItem) {
            // validation for constraint: itemType
            if (!$personalizacaoRetornoWsVoRespostasListItem instanceof \StructType\PersonalizacaoDadosWsVo) {
                $invalidValues[] = is_object($personalizacaoRetornoWsVoRespostasListItem) ? get_class($personalizacaoRetornoWsVoRespostasListItem) : sprintf('%s(%s)', gettype($personalizacaoRetornoWsVoRespostasListItem), var_export($personalizacaoRetornoWsVoRespostasListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The respostasList property can only contain items of type \StructType\PersonalizacaoDadosWsVo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set respostasList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PersonalizacaoDadosWsVo[] $respostasList
     * @return \StructType\PersonalizacaoRetornoWsVo
     */
    public function setRespostasList(array $respostasList = array())
    {
        // validation for constraint: array
        if ('' !== ($respostasListArrayErrorMessage = self::validateRespostasListForArrayConstraintsFromSetRespostasList($respostasList))) {
            throw new \InvalidArgumentException($respostasListArrayErrorMessage, __LINE__);
        }
        if (is_null($respostasList) || (is_array($respostasList) && empty($respostasList))) {
            unset($this->respostasList);
        } else {
            $this->respostasList = $respostasList;
        }
        return $this;
    }
    /**
     * Add item to respostasList value
     * @throws \InvalidArgumentException
     * @param \StructType\PersonalizacaoDadosWsVo $item
     * @return \StructType\PersonalizacaoRetornoWsVo
     */
    public function addToRespostasList(\StructType\PersonalizacaoDadosWsVo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PersonalizacaoDadosWsVo) {
            throw new \InvalidArgumentException(sprintf('The respostasList property can only contain items of type \StructType\PersonalizacaoDadosWsVo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->respostasList[] = $item;
        return $this;
    }
}
