<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Respostas ServiceType
 * @subpackage Services
 */
class Respostas extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named respostasPersonalizacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\RespostasPersonalizacao $parameters
     * @return \StructType\RespostasPersonalizacaoResponse|bool
     */
    public function respostasPersonalizacao(\StructType\RespostasPersonalizacao $parameters)
    {
        try {
            $this->setResult($this->getSoapClient()->respostasPersonalizacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\RespostasPersonalizacaoResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
