<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for webServiceInfoGeralVo StructType
 * @subpackage Structs
 */
class WebServiceInfoGeralVo extends AbstractStructBase
{
    /**
     * The codigoMensagem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codigoMensagem;
    /**
     * The mensagem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $mensagem;
    /**
     * The mensagemOperacaoDetalheList
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\WebServiceInfoOperacaoDetalheVo[]
     */
    public $mensagemOperacaoDetalheList;
    /**
     * The numeroErros
     * @var int
     */
    public $numeroErros;
    /**
     * Constructor method for webServiceInfoGeralVo
     * @uses WebServiceInfoGeralVo::setCodigoMensagem()
     * @uses WebServiceInfoGeralVo::setMensagem()
     * @uses WebServiceInfoGeralVo::setMensagemOperacaoDetalheList()
     * @uses WebServiceInfoGeralVo::setNumeroErros()
     * @param string $codigoMensagem
     * @param string $mensagem
     * @param \StructType\WebServiceInfoOperacaoDetalheVo[] $mensagemOperacaoDetalheList
     * @param int $numeroErros
     */
    public function __construct($codigoMensagem = null, $mensagem = null, array $mensagemOperacaoDetalheList = array(), $numeroErros = null)
    {
        $this
            ->setCodigoMensagem($codigoMensagem)
            ->setMensagem($mensagem)
            ->setMensagemOperacaoDetalheList($mensagemOperacaoDetalheList)
            ->setNumeroErros($numeroErros);
    }
    /**
     * Get codigoMensagem value
     * @return string|null
     */
    public function getCodigoMensagem()
    {
        return $this->codigoMensagem;
    }
    /**
     * Set codigoMensagem value
     * @param string $codigoMensagem
     * @return \StructType\WebServiceInfoGeralVo
     */
    public function setCodigoMensagem($codigoMensagem = null)
    {
        // validation for constraint: string
        if (!is_null($codigoMensagem) && !is_string($codigoMensagem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoMensagem, true), gettype($codigoMensagem)), __LINE__);
        }
        $this->codigoMensagem = $codigoMensagem;
        return $this;
    }
    /**
     * Get mensagem value
     * @return string|null
     */
    public function getMensagem()
    {
        return $this->mensagem;
    }
    /**
     * Set mensagem value
     * @param string $mensagem
     * @return \StructType\WebServiceInfoGeralVo
     */
    public function setMensagem($mensagem = null)
    {
        // validation for constraint: string
        if (!is_null($mensagem) && !is_string($mensagem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mensagem, true), gettype($mensagem)), __LINE__);
        }
        $this->mensagem = $mensagem;
        return $this;
    }
    /**
     * Get mensagemOperacaoDetalheList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\WebServiceInfoOperacaoDetalheVo[]|null
     */
    public function getMensagemOperacaoDetalheList()
    {
        return isset($this->mensagemOperacaoDetalheList) ? $this->mensagemOperacaoDetalheList : null;
    }
    /**
     * This method is responsible for validating the values passed to the setMensagemOperacaoDetalheList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMensagemOperacaoDetalheList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMensagemOperacaoDetalheListForArrayConstraintsFromSetMensagemOperacaoDetalheList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $webServiceInfoGeralVoMensagemOperacaoDetalheListItem) {
            // validation for constraint: itemType
            if (!$webServiceInfoGeralVoMensagemOperacaoDetalheListItem instanceof \StructType\WebServiceInfoOperacaoDetalheVo) {
                $invalidValues[] = is_object($webServiceInfoGeralVoMensagemOperacaoDetalheListItem) ? get_class($webServiceInfoGeralVoMensagemOperacaoDetalheListItem) : sprintf('%s(%s)', gettype($webServiceInfoGeralVoMensagemOperacaoDetalheListItem), var_export($webServiceInfoGeralVoMensagemOperacaoDetalheListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The mensagemOperacaoDetalheList property can only contain items of type \StructType\WebServiceInfoOperacaoDetalheVo, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set mensagemOperacaoDetalheList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\WebServiceInfoOperacaoDetalheVo[] $mensagemOperacaoDetalheList
     * @return \StructType\WebServiceInfoGeralVo
     */
    public function setMensagemOperacaoDetalheList(array $mensagemOperacaoDetalheList = array())
    {
        // validation for constraint: array
        if ('' !== ($mensagemOperacaoDetalheListArrayErrorMessage = self::validateMensagemOperacaoDetalheListForArrayConstraintsFromSetMensagemOperacaoDetalheList($mensagemOperacaoDetalheList))) {
            throw new \InvalidArgumentException($mensagemOperacaoDetalheListArrayErrorMessage, __LINE__);
        }
        if (is_null($mensagemOperacaoDetalheList) || (is_array($mensagemOperacaoDetalheList) && empty($mensagemOperacaoDetalheList))) {
            unset($this->mensagemOperacaoDetalheList);
        } else {
            $this->mensagemOperacaoDetalheList = $mensagemOperacaoDetalheList;
        }
        return $this;
    }
    /**
     * Add item to mensagemOperacaoDetalheList value
     * @throws \InvalidArgumentException
     * @param \StructType\WebServiceInfoOperacaoDetalheVo $item
     * @return \StructType\WebServiceInfoGeralVo
     */
    public function addToMensagemOperacaoDetalheList(\StructType\WebServiceInfoOperacaoDetalheVo $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\WebServiceInfoOperacaoDetalheVo) {
            throw new \InvalidArgumentException(sprintf('The mensagemOperacaoDetalheList property can only contain items of type \StructType\WebServiceInfoOperacaoDetalheVo, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->mensagemOperacaoDetalheList[] = $item;
        return $this;
    }
    /**
     * Get numeroErros value
     * @return int|null
     */
    public function getNumeroErros()
    {
        return $this->numeroErros;
    }
    /**
     * Set numeroErros value
     * @param int $numeroErros
     * @return \StructType\WebServiceInfoGeralVo
     */
    public function setNumeroErros($numeroErros = null)
    {
        // validation for constraint: int
        if (!is_null($numeroErros) && !(is_int($numeroErros) || ctype_digit($numeroErros))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numeroErros, true), gettype($numeroErros)), __LINE__);
        }
        $this->numeroErros = $numeroErros;
        return $this;
    }
}
