<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for resultadoExamesDadosWsVo StructType
 * @subpackage Structs
 */
class ResultadoExamesDadosWsVo extends AbstractStructBase
{
    /**
     * The alteraFichaClinica
     * @var bool
     */
    public $alteraFichaClinica;
    /**
     * The audiomatria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ResultadoExamesAudiometriaWsVo
     */
    public $audiomatria;
    /**
     * The codigoExame
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codigoExame;
    /**
     * The codigoExaminador
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codigoExaminador;
    /**
     * The codigoExaminador2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codigoExaminador2;
    /**
     * The codigoPrestador
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codigoPrestador;
    /**
     * The comentario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $comentario;
    /**
     * The criaExame
     * @var bool
     */
    public $criaExame;
    /**
     * The criaFichaClinica
     * @var bool
     */
    public $criaFichaClinica;
    /**
     * The dataResultadoExame
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dataResultadoExame;
    /**
     * The espirometria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ResultadoExamesEspirometriaWsVo
     */
    public $espirometria;
    /**
     * The fichaClinicaWsVo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ResultadoExamesFichaClinicaWsVo
     */
    public $fichaClinicaWsVo;
    /**
     * The hemograma
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ResultadoExamesHemogramaWsVo
     */
    public $hemograma;
    /**
     * The identificarExameAlteradoAutomaticamente
     * @var bool
     */
    public $identificarExameAlteradoAutomaticamente;
    /**
     * The metodo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $metodo;
    /**
     * The nomeExame
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nomeExame;
    /**
     * The nomeExaminador3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nomeExaminador3;
    /**
     * The nomeImagem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $nomeImagem;
    /**
     * The notaFiscal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $notaFiscal;
    /**
     * The resultado
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $resultado;
    /**
     * The resultadoAlterado
     * @var bool
     */
    public $resultadoAlterado;
    /**
     * The resultadoAlteradoAgravamento
     * @var bool
     */
    public $resultadoAlteradoAgravamento;
    /**
     * The resultadoAlteradoEmAnalise
     * @var bool
     */
    public $resultadoAlteradoEmAnalise;
    /**
     * The resultadoAlteradoOcupacional
     * @var bool
     */
    public $resultadoAlteradoOcupacional;
    /**
     * The resultadoReferencialSequencial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $resultadoReferencialSequencial;
    /**
     * The sobrepoeResultadoExistente
     * @var bool
     */
    public $sobrepoeResultadoExistente;
    /**
     * The urina
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\ResultadoExamesUrinaWsVo
     */
    public $urina;
    /**
     * The cnpjLaboratorio
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $cnpjLaboratorio;
    /**
     * The codigoExameLaboratorial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $codigoExameLaboratorial;
    /**
     * The ordemExameEsocial
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ordemExameEsocial;
    /**
     * Constructor method for resultadoExamesDadosWsVo
     * @uses ResultadoExamesDadosWsVo::setAlteraFichaClinica()
     * @uses ResultadoExamesDadosWsVo::setAudiomatria()
     * @uses ResultadoExamesDadosWsVo::setCodigoExame()
     * @uses ResultadoExamesDadosWsVo::setCodigoExaminador()
     * @uses ResultadoExamesDadosWsVo::setCodigoExaminador2()
     * @uses ResultadoExamesDadosWsVo::setCodigoPrestador()
     * @uses ResultadoExamesDadosWsVo::setComentario()
     * @uses ResultadoExamesDadosWsVo::setCriaExame()
     * @uses ResultadoExamesDadosWsVo::setCriaFichaClinica()
     * @uses ResultadoExamesDadosWsVo::setDataResultadoExame()
     * @uses ResultadoExamesDadosWsVo::setEspirometria()
     * @uses ResultadoExamesDadosWsVo::setFichaClinicaWsVo()
     * @uses ResultadoExamesDadosWsVo::setHemograma()
     * @uses ResultadoExamesDadosWsVo::setIdentificarExameAlteradoAutomaticamente()
     * @uses ResultadoExamesDadosWsVo::setMetodo()
     * @uses ResultadoExamesDadosWsVo::setNomeExame()
     * @uses ResultadoExamesDadosWsVo::setNomeExaminador3()
     * @uses ResultadoExamesDadosWsVo::setNomeImagem()
     * @uses ResultadoExamesDadosWsVo::setNotaFiscal()
     * @uses ResultadoExamesDadosWsVo::setResultado()
     * @uses ResultadoExamesDadosWsVo::setResultadoAlterado()
     * @uses ResultadoExamesDadosWsVo::setResultadoAlteradoAgravamento()
     * @uses ResultadoExamesDadosWsVo::setResultadoAlteradoEmAnalise()
     * @uses ResultadoExamesDadosWsVo::setResultadoAlteradoOcupacional()
     * @uses ResultadoExamesDadosWsVo::setResultadoReferencialSequencial()
     * @uses ResultadoExamesDadosWsVo::setSobrepoeResultadoExistente()
     * @uses ResultadoExamesDadosWsVo::setUrina()
     * @uses ResultadoExamesDadosWsVo::setCnpjLaboratorio()
     * @uses ResultadoExamesDadosWsVo::setCodigoExameLaboratorial()
     * @uses ResultadoExamesDadosWsVo::setOrdemExameEsocial()
     * @param bool $alteraFichaClinica
     * @param \StructType\ResultadoExamesAudiometriaWsVo $audiomatria
     * @param string $codigoExame
     * @param string $codigoExaminador
     * @param string $codigoExaminador2
     * @param string $codigoPrestador
     * @param string $comentario
     * @param bool $criaExame
     * @param bool $criaFichaClinica
     * @param string $dataResultadoExame
     * @param \StructType\ResultadoExamesEspirometriaWsVo $espirometria
     * @param \StructType\ResultadoExamesFichaClinicaWsVo $fichaClinicaWsVo
     * @param \StructType\ResultadoExamesHemogramaWsVo $hemograma
     * @param bool $identificarExameAlteradoAutomaticamente
     * @param string $metodo
     * @param string $nomeExame
     * @param string $nomeExaminador3
     * @param string $nomeImagem
     * @param string $notaFiscal
     * @param string $resultado
     * @param bool $resultadoAlterado
     * @param bool $resultadoAlteradoAgravamento
     * @param bool $resultadoAlteradoEmAnalise
     * @param bool $resultadoAlteradoOcupacional
     * @param string $resultadoReferencialSequencial
     * @param bool $sobrepoeResultadoExistente
     * @param \StructType\ResultadoExamesUrinaWsVo $urina
     * @param string $cnpjLaboratorio
     * @param string $codigoExameLaboratorial
     * @param string $ordemExameEsocial
     */
    public function __construct($alteraFichaClinica = null, \StructType\ResultadoExamesAudiometriaWsVo $audiomatria = null, $codigoExame = null, $codigoExaminador = null, $codigoExaminador2 = null, $codigoPrestador = null, $comentario = null, $criaExame = null, $criaFichaClinica = null, $dataResultadoExame = null, \StructType\ResultadoExamesEspirometriaWsVo $espirometria = null, \StructType\ResultadoExamesFichaClinicaWsVo $fichaClinicaWsVo = null, \StructType\ResultadoExamesHemogramaWsVo $hemograma = null, $identificarExameAlteradoAutomaticamente = null, $metodo = null, $nomeExame = null, $nomeExaminador3 = null, $nomeImagem = null, $notaFiscal = null, $resultado = null, $resultadoAlterado = null, $resultadoAlteradoAgravamento = null, $resultadoAlteradoEmAnalise = null, $resultadoAlteradoOcupacional = null, $resultadoReferencialSequencial = null, $sobrepoeResultadoExistente = null, \StructType\ResultadoExamesUrinaWsVo $urina = null, $cnpjLaboratorio = null, $codigoExameLaboratorial = null, $ordemExameEsocial = null)
    {
        $this
            ->setAlteraFichaClinica($alteraFichaClinica)
            ->setAudiomatria($audiomatria)
            ->setCodigoExame($codigoExame)
            ->setCodigoExaminador($codigoExaminador)
            ->setCodigoExaminador2($codigoExaminador2)
            ->setCodigoPrestador($codigoPrestador)
            ->setComentario($comentario)
            ->setCriaExame($criaExame)
            ->setCriaFichaClinica($criaFichaClinica)
            ->setDataResultadoExame($dataResultadoExame)
            ->setEspirometria($espirometria)
            ->setFichaClinicaWsVo($fichaClinicaWsVo)
            ->setHemograma($hemograma)
            ->setIdentificarExameAlteradoAutomaticamente($identificarExameAlteradoAutomaticamente)
            ->setMetodo($metodo)
            ->setNomeExame($nomeExame)
            ->setNomeExaminador3($nomeExaminador3)
            ->setNomeImagem($nomeImagem)
            ->setNotaFiscal($notaFiscal)
            ->setResultado($resultado)
            ->setResultadoAlterado($resultadoAlterado)
            ->setResultadoAlteradoAgravamento($resultadoAlteradoAgravamento)
            ->setResultadoAlteradoEmAnalise($resultadoAlteradoEmAnalise)
            ->setResultadoAlteradoOcupacional($resultadoAlteradoOcupacional)
            ->setResultadoReferencialSequencial($resultadoReferencialSequencial)
            ->setSobrepoeResultadoExistente($sobrepoeResultadoExistente)
            ->setUrina($urina)
            ->setCnpjLaboratorio($cnpjLaboratorio)
            ->setCodigoExameLaboratorial($codigoExameLaboratorial)
            ->setOrdemExameEsocial($ordemExameEsocial);
    }
    /**
     * Get alteraFichaClinica value
     * @return bool|null
     */
    public function getAlteraFichaClinica()
    {
        return $this->alteraFichaClinica;
    }
    /**
     * Set alteraFichaClinica value
     * @param bool $alteraFichaClinica
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setAlteraFichaClinica($alteraFichaClinica = null)
    {
        // validation for constraint: boolean
        if (!is_null($alteraFichaClinica) && !is_bool($alteraFichaClinica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($alteraFichaClinica, true), gettype($alteraFichaClinica)), __LINE__);
        }
        $this->alteraFichaClinica = $alteraFichaClinica;
        return $this;
    }
    /**
     * Get audiomatria value
     * @return \StructType\ResultadoExamesAudiometriaWsVo|null
     */
    public function getAudiomatria()
    {
        return $this->audiomatria;
    }
    /**
     * Set audiomatria value
     * @param \StructType\ResultadoExamesAudiometriaWsVo $audiomatria
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setAudiomatria(\StructType\ResultadoExamesAudiometriaWsVo $audiomatria = null)
    {
        $this->audiomatria = $audiomatria;
        return $this;
    }
    /**
     * Get codigoExame value
     * @return string|null
     */
    public function getCodigoExame()
    {
        return $this->codigoExame;
    }
    /**
     * Set codigoExame value
     * @param string $codigoExame
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setCodigoExame($codigoExame = null)
    {
        // validation for constraint: string
        if (!is_null($codigoExame) && !is_string($codigoExame)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoExame, true), gettype($codigoExame)), __LINE__);
        }
        $this->codigoExame = $codigoExame;
        return $this;
    }
    /**
     * Get codigoExaminador value
     * @return string|null
     */
    public function getCodigoExaminador()
    {
        return $this->codigoExaminador;
    }
    /**
     * Set codigoExaminador value
     * @param string $codigoExaminador
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setCodigoExaminador($codigoExaminador = null)
    {
        // validation for constraint: string
        if (!is_null($codigoExaminador) && !is_string($codigoExaminador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoExaminador, true), gettype($codigoExaminador)), __LINE__);
        }
        $this->codigoExaminador = $codigoExaminador;
        return $this;
    }
    /**
     * Get codigoExaminador2 value
     * @return string|null
     */
    public function getCodigoExaminador2()
    {
        return $this->codigoExaminador2;
    }
    /**
     * Set codigoExaminador2 value
     * @param string $codigoExaminador2
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setCodigoExaminador2($codigoExaminador2 = null)
    {
        // validation for constraint: string
        if (!is_null($codigoExaminador2) && !is_string($codigoExaminador2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoExaminador2, true), gettype($codigoExaminador2)), __LINE__);
        }
        $this->codigoExaminador2 = $codigoExaminador2;
        return $this;
    }
    /**
     * Get codigoPrestador value
     * @return string|null
     */
    public function getCodigoPrestador()
    {
        return $this->codigoPrestador;
    }
    /**
     * Set codigoPrestador value
     * @param string $codigoPrestador
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setCodigoPrestador($codigoPrestador = null)
    {
        // validation for constraint: string
        if (!is_null($codigoPrestador) && !is_string($codigoPrestador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoPrestador, true), gettype($codigoPrestador)), __LINE__);
        }
        $this->codigoPrestador = $codigoPrestador;
        return $this;
    }
    /**
     * Get comentario value
     * @return string|null
     */
    public function getComentario()
    {
        return $this->comentario;
    }
    /**
     * Set comentario value
     * @param string $comentario
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setComentario($comentario = null)
    {
        // validation for constraint: string
        if (!is_null($comentario) && !is_string($comentario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comentario, true), gettype($comentario)), __LINE__);
        }
        $this->comentario = $comentario;
        return $this;
    }
    /**
     * Get criaExame value
     * @return bool|null
     */
    public function getCriaExame()
    {
        return $this->criaExame;
    }
    /**
     * Set criaExame value
     * @param bool $criaExame
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setCriaExame($criaExame = null)
    {
        // validation for constraint: boolean
        if (!is_null($criaExame) && !is_bool($criaExame)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($criaExame, true), gettype($criaExame)), __LINE__);
        }
        $this->criaExame = $criaExame;
        return $this;
    }
    /**
     * Get criaFichaClinica value
     * @return bool|null
     */
    public function getCriaFichaClinica()
    {
        return $this->criaFichaClinica;
    }
    /**
     * Set criaFichaClinica value
     * @param bool $criaFichaClinica
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setCriaFichaClinica($criaFichaClinica = null)
    {
        // validation for constraint: boolean
        if (!is_null($criaFichaClinica) && !is_bool($criaFichaClinica)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($criaFichaClinica, true), gettype($criaFichaClinica)), __LINE__);
        }
        $this->criaFichaClinica = $criaFichaClinica;
        return $this;
    }
    /**
     * Get dataResultadoExame value
     * @return string|null
     */
    public function getDataResultadoExame()
    {
        return $this->dataResultadoExame;
    }
    /**
     * Set dataResultadoExame value
     * @param string $dataResultadoExame
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setDataResultadoExame($dataResultadoExame = null)
    {
        // validation for constraint: string
        if (!is_null($dataResultadoExame) && !is_string($dataResultadoExame)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dataResultadoExame, true), gettype($dataResultadoExame)), __LINE__);
        }
        $this->dataResultadoExame = $dataResultadoExame;
        return $this;
    }
    /**
     * Get espirometria value
     * @return \StructType\ResultadoExamesEspirometriaWsVo|null
     */
    public function getEspirometria()
    {
        return $this->espirometria;
    }
    /**
     * Set espirometria value
     * @param \StructType\ResultadoExamesEspirometriaWsVo $espirometria
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setEspirometria(\StructType\ResultadoExamesEspirometriaWsVo $espirometria = null)
    {
        $this->espirometria = $espirometria;
        return $this;
    }
    /**
     * Get fichaClinicaWsVo value
     * @return \StructType\ResultadoExamesFichaClinicaWsVo|null
     */
    public function getFichaClinicaWsVo()
    {
        return $this->fichaClinicaWsVo;
    }
    /**
     * Set fichaClinicaWsVo value
     * @param \StructType\ResultadoExamesFichaClinicaWsVo $fichaClinicaWsVo
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setFichaClinicaWsVo(\StructType\ResultadoExamesFichaClinicaWsVo $fichaClinicaWsVo = null)
    {
        $this->fichaClinicaWsVo = $fichaClinicaWsVo;
        return $this;
    }
    /**
     * Get hemograma value
     * @return \StructType\ResultadoExamesHemogramaWsVo|null
     */
    public function getHemograma()
    {
        return $this->hemograma;
    }
    /**
     * Set hemograma value
     * @param \StructType\ResultadoExamesHemogramaWsVo $hemograma
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setHemograma(\StructType\ResultadoExamesHemogramaWsVo $hemograma = null)
    {
        $this->hemograma = $hemograma;
        return $this;
    }
    /**
     * Get identificarExameAlteradoAutomaticamente value
     * @return bool|null
     */
    public function getIdentificarExameAlteradoAutomaticamente()
    {
        return $this->identificarExameAlteradoAutomaticamente;
    }
    /**
     * Set identificarExameAlteradoAutomaticamente value
     * @param bool $identificarExameAlteradoAutomaticamente
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setIdentificarExameAlteradoAutomaticamente($identificarExameAlteradoAutomaticamente = null)
    {
        // validation for constraint: boolean
        if (!is_null($identificarExameAlteradoAutomaticamente) && !is_bool($identificarExameAlteradoAutomaticamente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($identificarExameAlteradoAutomaticamente, true), gettype($identificarExameAlteradoAutomaticamente)), __LINE__);
        }
        $this->identificarExameAlteradoAutomaticamente = $identificarExameAlteradoAutomaticamente;
        return $this;
    }
    /**
     * Get metodo value
     * @return string|null
     */
    public function getMetodo()
    {
        return $this->metodo;
    }
    /**
     * Set metodo value
     * @param string $metodo
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setMetodo($metodo = null)
    {
        // validation for constraint: string
        if (!is_null($metodo) && !is_string($metodo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($metodo, true), gettype($metodo)), __LINE__);
        }
        $this->metodo = $metodo;
        return $this;
    }
    /**
     * Get nomeExame value
     * @return string|null
     */
    public function getNomeExame()
    {
        return $this->nomeExame;
    }
    /**
     * Set nomeExame value
     * @param string $nomeExame
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setNomeExame($nomeExame = null)
    {
        // validation for constraint: string
        if (!is_null($nomeExame) && !is_string($nomeExame)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeExame, true), gettype($nomeExame)), __LINE__);
        }
        $this->nomeExame = $nomeExame;
        return $this;
    }
    /**
     * Get nomeExaminador3 value
     * @return string|null
     */
    public function getNomeExaminador3()
    {
        return $this->nomeExaminador3;
    }
    /**
     * Set nomeExaminador3 value
     * @param string $nomeExaminador3
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setNomeExaminador3($nomeExaminador3 = null)
    {
        // validation for constraint: string
        if (!is_null($nomeExaminador3) && !is_string($nomeExaminador3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeExaminador3, true), gettype($nomeExaminador3)), __LINE__);
        }
        $this->nomeExaminador3 = $nomeExaminador3;
        return $this;
    }
    /**
     * Get nomeImagem value
     * @return string|null
     */
    public function getNomeImagem()
    {
        return $this->nomeImagem;
    }
    /**
     * Set nomeImagem value
     * @param string $nomeImagem
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setNomeImagem($nomeImagem = null)
    {
        // validation for constraint: string
        if (!is_null($nomeImagem) && !is_string($nomeImagem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nomeImagem, true), gettype($nomeImagem)), __LINE__);
        }
        $this->nomeImagem = $nomeImagem;
        return $this;
    }
    /**
     * Get notaFiscal value
     * @return string|null
     */
    public function getNotaFiscal()
    {
        return $this->notaFiscal;
    }
    /**
     * Set notaFiscal value
     * @param string $notaFiscal
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setNotaFiscal($notaFiscal = null)
    {
        // validation for constraint: string
        if (!is_null($notaFiscal) && !is_string($notaFiscal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notaFiscal, true), gettype($notaFiscal)), __LINE__);
        }
        $this->notaFiscal = $notaFiscal;
        return $this;
    }
    /**
     * Get resultado value
     * @return string|null
     */
    public function getResultado()
    {
        return $this->resultado;
    }
    /**
     * Set resultado value
     * @param string $resultado
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setResultado($resultado = null)
    {
        // validation for constraint: string
        if (!is_null($resultado) && !is_string($resultado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultado, true), gettype($resultado)), __LINE__);
        }
        $this->resultado = $resultado;
        return $this;
    }
    /**
     * Get resultadoAlterado value
     * @return bool|null
     */
    public function getResultadoAlterado()
    {
        return $this->resultadoAlterado;
    }
    /**
     * Set resultadoAlterado value
     * @param bool $resultadoAlterado
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setResultadoAlterado($resultadoAlterado = null)
    {
        // validation for constraint: boolean
        if (!is_null($resultadoAlterado) && !is_bool($resultadoAlterado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($resultadoAlterado, true), gettype($resultadoAlterado)), __LINE__);
        }
        $this->resultadoAlterado = $resultadoAlterado;
        return $this;
    }
    /**
     * Get resultadoAlteradoAgravamento value
     * @return bool|null
     */
    public function getResultadoAlteradoAgravamento()
    {
        return $this->resultadoAlteradoAgravamento;
    }
    /**
     * Set resultadoAlteradoAgravamento value
     * @param bool $resultadoAlteradoAgravamento
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setResultadoAlteradoAgravamento($resultadoAlteradoAgravamento = null)
    {
        // validation for constraint: boolean
        if (!is_null($resultadoAlteradoAgravamento) && !is_bool($resultadoAlteradoAgravamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($resultadoAlteradoAgravamento, true), gettype($resultadoAlteradoAgravamento)), __LINE__);
        }
        $this->resultadoAlteradoAgravamento = $resultadoAlteradoAgravamento;
        return $this;
    }
    /**
     * Get resultadoAlteradoEmAnalise value
     * @return bool|null
     */
    public function getResultadoAlteradoEmAnalise()
    {
        return $this->resultadoAlteradoEmAnalise;
    }
    /**
     * Set resultadoAlteradoEmAnalise value
     * @param bool $resultadoAlteradoEmAnalise
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setResultadoAlteradoEmAnalise($resultadoAlteradoEmAnalise = null)
    {
        // validation for constraint: boolean
        if (!is_null($resultadoAlteradoEmAnalise) && !is_bool($resultadoAlteradoEmAnalise)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($resultadoAlteradoEmAnalise, true), gettype($resultadoAlteradoEmAnalise)), __LINE__);
        }
        $this->resultadoAlteradoEmAnalise = $resultadoAlteradoEmAnalise;
        return $this;
    }
    /**
     * Get resultadoAlteradoOcupacional value
     * @return bool|null
     */
    public function getResultadoAlteradoOcupacional()
    {
        return $this->resultadoAlteradoOcupacional;
    }
    /**
     * Set resultadoAlteradoOcupacional value
     * @param bool $resultadoAlteradoOcupacional
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setResultadoAlteradoOcupacional($resultadoAlteradoOcupacional = null)
    {
        // validation for constraint: boolean
        if (!is_null($resultadoAlteradoOcupacional) && !is_bool($resultadoAlteradoOcupacional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($resultadoAlteradoOcupacional, true), gettype($resultadoAlteradoOcupacional)), __LINE__);
        }
        $this->resultadoAlteradoOcupacional = $resultadoAlteradoOcupacional;
        return $this;
    }
    /**
     * Get resultadoReferencialSequencial value
     * @return string|null
     */
    public function getResultadoReferencialSequencial()
    {
        return $this->resultadoReferencialSequencial;
    }
    /**
     * Set resultadoReferencialSequencial value
     * @uses \EnumType\TipoRefrencialSequencial::valueIsValid()
     * @uses \EnumType\TipoRefrencialSequencial::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resultadoReferencialSequencial
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setResultadoReferencialSequencial($resultadoReferencialSequencial = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\TipoRefrencialSequencial::valueIsValid($resultadoReferencialSequencial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\TipoRefrencialSequencial', is_array($resultadoReferencialSequencial) ? implode(', ', $resultadoReferencialSequencial) : var_export($resultadoReferencialSequencial, true), implode(', ', \EnumType\TipoRefrencialSequencial::getValidValues())), __LINE__);
        }
        $this->resultadoReferencialSequencial = $resultadoReferencialSequencial;
        return $this;
    }
    /**
     * Get sobrepoeResultadoExistente value
     * @return bool|null
     */
    public function getSobrepoeResultadoExistente()
    {
        return $this->sobrepoeResultadoExistente;
    }
    /**
     * Set sobrepoeResultadoExistente value
     * @param bool $sobrepoeResultadoExistente
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setSobrepoeResultadoExistente($sobrepoeResultadoExistente = null)
    {
        // validation for constraint: boolean
        if (!is_null($sobrepoeResultadoExistente) && !is_bool($sobrepoeResultadoExistente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sobrepoeResultadoExistente, true), gettype($sobrepoeResultadoExistente)), __LINE__);
        }
        $this->sobrepoeResultadoExistente = $sobrepoeResultadoExistente;
        return $this;
    }
    /**
     * Get urina value
     * @return \StructType\ResultadoExamesUrinaWsVo|null
     */
    public function getUrina()
    {
        return $this->urina;
    }
    /**
     * Set urina value
     * @param \StructType\ResultadoExamesUrinaWsVo $urina
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setUrina(\StructType\ResultadoExamesUrinaWsVo $urina = null)
    {
        $this->urina = $urina;
        return $this;
    }
    /**
     * Get cnpjLaboratorio value
     * @return string|null
     */
    public function getCnpjLaboratorio()
    {
        return $this->cnpjLaboratorio;
    }
    /**
     * Set cnpjLaboratorio value
     * @param string $cnpjLaboratorio
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setCnpjLaboratorio($cnpjLaboratorio = null)
    {
        // validation for constraint: string
        if (!is_null($cnpjLaboratorio) && !is_string($cnpjLaboratorio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cnpjLaboratorio, true), gettype($cnpjLaboratorio)), __LINE__);
        }
        $this->cnpjLaboratorio = $cnpjLaboratorio;
        return $this;
    }
    /**
     * Get codigoExameLaboratorial value
     * @return string|null
     */
    public function getCodigoExameLaboratorial()
    {
        return $this->codigoExameLaboratorial;
    }
    /**
     * Set codigoExameLaboratorial value
     * @param string $codigoExameLaboratorial
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setCodigoExameLaboratorial($codigoExameLaboratorial = null)
    {
        // validation for constraint: string
        if (!is_null($codigoExameLaboratorial) && !is_string($codigoExameLaboratorial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codigoExameLaboratorial, true), gettype($codigoExameLaboratorial)), __LINE__);
        }
        $this->codigoExameLaboratorial = $codigoExameLaboratorial;
        return $this;
    }
    /**
     * Get ordemExameEsocial value
     * @return string|null
     */
    public function getOrdemExameEsocial()
    {
        return $this->ordemExameEsocial;
    }
    /**
     * Set ordemExameEsocial value
     * @uses \EnumType\OrdemExameEsocialEnum::valueIsValid()
     * @uses \EnumType\OrdemExameEsocialEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ordemExameEsocial
     * @return \StructType\ResultadoExamesDadosWsVo
     */
    public function setOrdemExameEsocial($ordemExameEsocial = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\OrdemExameEsocialEnum::valueIsValid($ordemExameEsocial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \EnumType\OrdemExameEsocialEnum', is_array($ordemExameEsocial) ? implode(', ', $ordemExameEsocial) : var_export($ordemExameEsocial, true), implode(', ', \EnumType\OrdemExameEsocialEnum::getValidValues())), __LINE__);
        }
        $this->ordemExameEsocial = $ordemExameEsocial;
        return $this;
    }
}
